/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.recipe.cache;

import com.google.common.collect.ImmutableSet;
import forestry.core.ClientsideCode;
import java.util.function.Consumer;
import net.minecraft.util.Unit;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.loading.FMLEnvironment;
import thedarkcolour.gendustry.recipe.cache.IRecipeCache;

public final class RecipeCacheRegistry {
    private final ImmutableSet<IRecipeCache> caches;
    private boolean needsReload;

    public RecipeCacheRegistry(Consumer<Consumer<IRecipeCache>> registerCaches) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        registerCaches.accept(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.caches = builder.build();
        MinecraftForge.EVENT_BUS.addListener(event -> this.unload());
        MinecraftForge.EVENT_BUS.addListener(event -> {
            RecipeManager recipes = event.getServerResources().m_206887_();
            event.addListener((prepBarrier, resourceManager, prepProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> prepBarrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(() -> this.reload(recipes), gameExecutor));
        });
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(event -> {
                RecipeManager recipes = ClientsideCode.getRecipeManager();
                if (this.needsReload && recipes != null) {
                    this.reload(recipes);
                    this.needsReload = false;
                }
            });
        }
    }

    private void reload(RecipeManager recipes) {
        for (IRecipeCache cache : this.caches) {
            cache.reload(recipes);
        }
    }

    private void unload() {
        for (IRecipeCache cache : this.caches) {
            cache.unload();
        }
    }
}

