/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.registry;

import forestry.api.IForestryApi;
import forestry.api.core.IFeatureSubtype;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.core.tab.ForestryCreativeTabs;
import forestry.modules.features.FeatureCreativeTab;
import forestry.modules.features.FeatureProvider;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.ModFeatureRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import thedarkcolour.gendustry.GendustryModule;
import thedarkcolour.gendustry.block.GendustryMachineType;
import thedarkcolour.gendustry.item.GeneSampleItem;
import thedarkcolour.gendustry.registry.GBlocks;
import thedarkcolour.gendustry.registry.GFluids;
import thedarkcolour.gendustry.registry.GItems;

@FeatureProvider
public class GCreativeTabs {
    private static final IFeatureRegistry REGISTRY = ModFeatureRegistry.get((ResourceLocation)GendustryModule.MODULE_ID);
    public static final FeatureCreativeTab GENDUSTRY = REGISTRY.creativeTab("gendustry", tab -> {
        tab.m_257737_(() -> GBlocks.MACHINE.stack((IFeatureSubtype)GendustryMachineType.INDUSTRIAL_APIARY));
        tab.m_257501_(GCreativeTabs::addGendustryItems);
        tab.withTabsBefore(new ResourceKey[]{ForestryCreativeTabs.MAIL.getKey()});
        tab.withTabsAfter(new ResourceKey[]{GENE_SAMPLES.getKey()});
    });
    public static final FeatureCreativeTab GENE_SAMPLES = REGISTRY.creativeTab("gene_samples", tab -> {
        tab.m_257737_(() -> GItems.GENE_SAMPLE.stack());
        tab.m_257501_(GCreativeTabs::addGeneSamples);
        tab.withTabsBefore(new ResourceKey[]{GENDUSTRY.getKey()});
    });

    private static void addGendustryItems(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        GBlocks.MACHINE.getBlocks().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        items.m_246326_(GItems.POLLEN_KIT);
        items.m_246326_((ItemLike)GFluids.MUTAGEN.getBucket());
        items.m_246326_((ItemLike)GFluids.LIQUID_DNA.getBucket());
        items.m_246326_((ItemLike)GFluids.PROTEIN.getBucket());
        GItems.RESOURCE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        GItems.UPGRADE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
        GItems.ELITE_UPGRADE.getItems().forEach(arg_0 -> ((CreativeModeTab.Output)items).m_246326_(arg_0));
    }

    private static void addGeneSamples(CreativeModeTab.ItemDisplayParameters params, CreativeModeTab.Output items) {
        for (ISpeciesType speciesType : IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypes()) {
            IKaryotype karyotype = speciesType.getKaryotype();
            for (IChromosome chromosome : karyotype.getChromosomes()) {
                for (IAllele allele : karyotype.getAlleles(chromosome)) {
                    items.m_246342_(GeneSampleItem.createStack(speciesType, chromosome, allele));
                }
            }
        }
    }
}

