/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech;

import com.mojang.logging.LogUtils;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import ru.auriny.infinitech.Events;
import ru.auriny.infinitech.core.data.BlockStateGen;
import ru.auriny.infinitech.core.data.ItemModelGen;
import ru.auriny.infinitech.core.data.RecipeGen;
import ru.auriny.infinitech.core.data.base.LootTableGen;
import ru.auriny.infinitech.registries.BlockRegistry;
import ru.auriny.infinitech.registries.CreativeTabsRegistry;
import ru.auriny.infinitech.registries.EntityRegistry;
import ru.auriny.infinitech.registries.ItemRegistry;
import ru.auriny.infinitech.registries.MenuRegistry;
import ru.auriny.infinitech.registries.RecipesRegistry;
import ru.auriny.infinitech.registries.SoundsRegistry;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.item.SkinsRegistry;

@Mod(value="infinitech")
public class InfiniTech {
    public static final String ID = "infinitech";
    public static final Logger LOGGER = LogUtils.getLogger();

    public InfiniTech() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SoundsRegistry.register(modEventBus);
        ItemRegistry.ITEMS.register(modEventBus);
        BlockRegistry.BLOCK_ITEMS.register(modEventBus);
        BlockRegistry.BLOCKS.register(modEventBus);
        RecipesRegistry.register(modEventBus);
        TileEntityRegistry.BLOCK_ENTITIES.register(modEventBus);
        EntityRegistry.ENTITIES.register(modEventBus);
        MenuRegistry.register(modEventBus);
        CreativeTabsRegistry.register(modEventBus);
        SkinsRegistry.register();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.register(Events.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(ID, path);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ShapedRecipe.setCraftingSize((int)9, (int)9));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput packOutput = generator.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            generator.addProvider(event.includeServer(), (DataProvider)LootTableGen.create(packOutput));
            generator.addProvider(event.includeServer(), (DataProvider)new RecipeGen(packOutput));
            generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGen(packOutput, existingFileHelper));
            generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGen(packOutput, existingFileHelper));
        }
    }
}

