/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import ru.auriny.infinitech.client.InfinitechShaders;
import ru.auriny.infinitech.client.model.CosmicModelLoader;
import ru.auriny.infinitech.client.model.HaloItemModelLoader;
import ru.auriny.infinitech.client.render.AbstractKomaruArrowRenderer;
import ru.auriny.infinitech.client.render.InjectorCoreTileRenderer;
import ru.auriny.infinitech.client.render.InjectorTileRenderer;
import ru.auriny.infinitech.client.screen.ExtremeCraftingScreen;
import ru.auriny.infinitech.client.screen.NeutroniumHarvesterScreen;
import ru.auriny.infinitech.client.screen.SolarPanelScreen;
import ru.auriny.infinitech.registries.EntityRegistry;
import ru.auriny.infinitech.registries.ItemRegistry;
import ru.auriny.infinitech.registries.MenuRegistry;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.item.SingularityItem;

@Mod.EventBusSubscriber(modid="infinitech", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class InfiniTechClient {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        EntityRegistry.onClientSetup();
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.SOLAR_PANEL_MENU.get()), SolarPanelScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.CRAFTING_MENU.get()), ExtremeCraftingScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.NEUTRONIUM_HARVESTER.get()), NeutroniumHarvesterScreen::new);
        });
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TileEntityRegistry.INJECTOR.get()), InjectorTileRenderer::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TileEntityRegistry.CORE_INJECTOR.get()), InjectorCoreTileRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.INFINITY_ARROW.get()), AbstractKomaruArrowRenderer::new);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRegisterShaders(RegisterShadersEvent event) {
        InfinitechShaders.init(event);
    }

    @SubscribeEvent
    public static void registerLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("cosmic", (IGeometryLoader)CosmicModelLoader.INSTANCE);
        event.register("halo", (IGeometryLoader)HaloItemModelLoader.INSTANCE);
    }

    @SubscribeEvent
    public static void ColorMappingItems(RegisterColorHandlersEvent.Item event) {
        for (RegistryObject items : ItemRegistry.ITEMS.getEntries()) {
            Item current = (Item)items.get();
            if (!(current instanceof SingularityItem)) continue;
            SingularityItem singularityItem = (SingularityItem)current;
            event.register((stack, tintIndex) -> singularityItem.color.rgb(), new ItemLike[]{singularityItem});
        }
    }
}

