/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import java.lang.reflect.Array;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import ru.auriny.infinitech.client.lib.Copyable;

public class ArrayUtils {
    public static <T> boolean isEmpty(T[] array) {
        for (T value : array) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public static <T> int count(T[] array, Function<T, Boolean> check) {
        int counter = 0;
        for (T value : array) {
            if (!check.apply(value).booleanValue()) continue;
            ++counter;
        }
        return counter;
    }

    public static void arrayCopy(Object src, int srcPos, Object dst, int destPos, int length) {
        System.arraycopy(src, srcPos, dst, destPos, length);
        if (dst instanceof Copyable[]) {
            Object[] oa = (Object[])dst;
            Copyable[] c = (Copyable[])dst;
            for (int i = destPos; i < destPos + length; ++i) {
                if (c[i] == null) continue;
                oa[i] = c[i].copy();
            }
        }
    }

    public static <T> T[] createNewArray(T[] array, int length) {
        Class<?> newType = array.getClass();
        Object[] copy = newType.equals(Object[].class) ? new Object[length] : ArrayUtils.newArray(newType.getComponentType(), length);
        return copy;
    }

    public static <T> T[] newArray(Class<T> arrayClass, int length) {
        return (Object[])Array.newInstance(arrayClass, length);
    }

    public static <T> boolean contains(T[] input, T element) {
        for (T test : input) {
            if (!Objects.equals(test, element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] inverse(T[] input, T[] allElements) {
        LinkedList<T> list = new LinkedList<T>();
        for (T e : allElements) {
            if (ArrayUtils.contains(input, e)) continue;
            list.add(e);
        }
        return list.toArray(ArrayUtils.createNewArray(input, list.size()));
    }
}

