/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.client.lib.AttributeKey;
import ru.auriny.infinitech.client.lib.CCRenderState;
import ru.auriny.infinitech.client.lib.ColourAttribute;
import ru.auriny.infinitech.client.lib.Copyable;
import ru.auriny.infinitech.client.lib.Cuboid6;
import ru.auriny.infinitech.client.lib.IVertexOperation;
import ru.auriny.infinitech.client.lib.IVertexSource;
import ru.auriny.infinitech.client.lib.ModelMaterial;
import ru.auriny.infinitech.client.lib.NormalAttribute;
import ru.auriny.infinitech.client.lib.SneakyUtils;
import ru.auriny.infinitech.client.lib.Transformation;
import ru.auriny.infinitech.client.lib.UVTransformation;
import ru.auriny.infinitech.client.lib.UVTranslation;
import ru.auriny.infinitech.client.lib.Vector3;
import ru.auriny.infinitech.client.lib.Vertex5;

public class CCModel
implements IVertexSource,
Copyable<CCModel> {
    public final VertexFormat.Mode vertexMode;
    public final int vp;
    public Vertex5[] verts;
    public ArrayList<Object> attributes = new ArrayList();

    protected CCModel(VertexFormat.Mode vertexMode) {
        if (vertexMode != VertexFormat.Mode.QUADS && vertexMode != VertexFormat.Mode.TRIANGLES) {
            throw new IllegalArgumentException("Models must be QUADS or TRIANGLES");
        }
        this.vertexMode = vertexMode;
        this.vp = vertexMode == VertexFormat.Mode.QUADS ? 4 : 3;
    }

    public Vector3[] normals() {
        return this.getAttribute(NormalAttribute.attributeKey);
    }

    @Nullable
    public ModelMaterial material() {
        return this.getAttribute(ModelMaterial.MATERIAL_KEY);
    }

    @Override
    public Vertex5[] getVertices() {
        return this.verts;
    }

    @Override
    public <T> T getAttribute(AttributeKey<T> attr) {
        if (attr.attributeKeyIndex < this.attributes.size()) {
            return SneakyUtils.unsafeCast(this.attributes.get(attr.attributeKeyIndex));
        }
        return null;
    }

    @Override
    public boolean hasAttribute(AttributeKey<?> attr) {
        return attr.attributeKeyIndex < this.attributes.size() && this.attributes.get(attr.attributeKeyIndex) != null;
    }

    @Override
    public void prepareVertex(CCRenderState ccrs) {
    }

    public <T> T getOrAllocate(AttributeKey<T> attr) {
        T value = this.getAttribute(attr);
        if (value == null) {
            this.allocateAttr(attr);
            value = attr.createDefault(this.verts.length);
            this.attributes.set(attr.attributeKeyIndex, value);
        }
        return value;
    }

    public <T> void setAttribute(AttributeKey<T> attr, @Nullable T value) {
        this.allocateAttr(attr);
        this.attributes.set(attr.attributeKeyIndex, value);
    }

    private void allocateAttr(AttributeKey<?> attr) {
        if (attr.attributeKeyIndex >= this.attributes.size()) {
            while (this.attributes.size() <= attr.attributeKeyIndex) {
                this.attributes.add(null);
            }
        }
    }

    public CCModel generateBlock(int i, Cuboid6 bounds) {
        return this.generateBlock(i, bounds, 0);
    }

    public CCModel generateBlock(int i, Cuboid6 bounds, int mask) {
        return this.generateBlock(i, bounds.min.x, bounds.min.y, bounds.min.z, bounds.max.x, bounds.max.y, bounds.max.z, mask);
    }

    public CCModel generateBlock(int i, double x1, double y1, double z1, double x2, double y2, double z2) {
        return this.generateBlock(i, x1, y1, z1, x2, y2, z2, 0);
    }

    public CCModel generateBlock(int i, double x1, double y1, double z1, double x2, double y2, double z2, int mask) {
        double v2;
        double u2;
        double v1;
        double u1;
        if ((mask & 1) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2, 0);
            this.verts[i++] = new Vertex5(x1, y1, z1, u1, v1, 0);
            this.verts[i++] = new Vertex5(x2, y1, z1, u2, v1, 0);
            this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2, 0);
        }
        if ((mask & 2) == 0) {
            u1 = x1;
            v1 = z1;
            u2 = x2;
            v2 = z2;
            this.verts[i++] = new Vertex5(x2, y2, z2, u2, v2, 1);
            this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1, 1);
            this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1, 1);
            this.verts[i++] = new Vertex5(x1, y2, z2, u1, v2, 1);
        }
        if ((mask & 4) == 0) {
            u1 = 1.0 - x1;
            v1 = 1.0 - y2;
            u2 = 1.0 - x2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2, 2);
            this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1, 2);
            this.verts[i++] = new Vertex5(x2, y2, z1, u2, v1, 2);
            this.verts[i++] = new Vertex5(x2, y1, z1, u2, v2, 2);
        }
        if ((mask & 8) == 0) {
            u1 = x1;
            v1 = 1.0 - y2;
            u2 = x2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2, 3);
            this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1, 3);
            this.verts[i++] = new Vertex5(x1, y2, z2, u1, v1, 3);
            this.verts[i++] = new Vertex5(x1, y1, z2, u1, v2, 3);
        }
        if ((mask & 0x10) == 0) {
            u1 = z1;
            v1 = 1.0 - y2;
            u2 = z2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x1, y1, z2, u2, v2, 4);
            this.verts[i++] = new Vertex5(x1, y2, z2, u2, v1, 4);
            this.verts[i++] = new Vertex5(x1, y2, z1, u1, v1, 4);
            this.verts[i++] = new Vertex5(x1, y1, z1, u1, v2, 4);
        }
        if ((mask & 0x20) == 0) {
            u1 = 1.0 - z1;
            v1 = 1.0 - y2;
            u2 = 1.0 - z2;
            v2 = 1.0 - y1;
            this.verts[i++] = new Vertex5(x2, y1, z1, u1, v2, 5);
            this.verts[i++] = new Vertex5(x2, y2, z1, u1, v1, 5);
            this.verts[i++] = new Vertex5(x2, y2, z2, u2, v1, 5);
            this.verts[i++] = new Vertex5(x2, y1, z2, u2, v2, 5);
        }
        return this;
    }

    public CCModel setColour(int c) {
        int[] colours = this.getOrAllocate(ColourAttribute.attributeKey);
        Arrays.fill(colours, c);
        return this;
    }

    public CCModel apply(Transformation t) {
        for (Vertex5 vert : this.verts) {
            vert.apply(t);
        }
        Vector3[] normals = this.normals();
        if (normals != null) {
            for (Vector3 normal : normals) {
                t.applyN(normal);
            }
        }
        return this;
    }

    public CCModel apply(UVTransformation uvt) {
        for (Vertex5 vert : this.verts) {
            vert.apply(uvt);
        }
        return this;
    }

    public void render(CCRenderState state, double x, double y, double z, double u, double v) {
        this.render(state, new Vector3(x, y, z).translation(), new UVTranslation(u, v));
    }

    public void render(CCRenderState state, double x, double y, double z, UVTransformation u) {
        this.render(state, new Vector3(x, y, z).translation(), u);
    }

    public void render(CCRenderState state, Transformation t, double u, double v) {
        this.render(state, t, new UVTranslation(u, v));
    }

    public void render(CCRenderState state, IVertexOperation ... ops) {
        this.render(state, 0, this.verts.length, ops);
    }

    public void render(CCRenderState state, int start, int end, IVertexOperation ... ops) {
        state.setPipeline(this, start, end, ops);
        state.render();
    }

    public static CCModel newModel(VertexFormat.Mode vertexMode, int numVerts) {
        CCModel model = CCModel.newModel(vertexMode);
        model.verts = new Vertex5[numVerts];
        return model;
    }

    public static CCModel newModel(VertexFormat.Mode vertexMode) {
        return new CCModel(vertexMode);
    }

    public static CCModel createModel(List<Vector3> verts, List<Vector3> uvs, List<Vector3> normals, VertexFormat.Mode vertexMode, List<int[]> polys) {
        int vp;
        int n = vp = vertexMode == VertexFormat.Mode.QUADS ? 4 : 3;
        if (polys.size() < vp || polys.size() % vp != 0) {
            throw new IllegalArgumentException("Invalid number of vertices for model: " + polys.size());
        }
        boolean hasNormals = polys.get(0)[2] > 0;
        CCModel model = CCModel.newModel(vertexMode, polys.size());
        if (hasNormals) {
            model.getOrAllocate(NormalAttribute.attributeKey);
        }
        for (int i = 0; i < polys.size(); ++i) {
            int[] ai = polys.get(i);
            Vector3 vert = verts.get(ai[0] - 1).copy();
            Vector3 uv = ai[1] <= 0 ? new Vector3() : uvs.get(ai[1] - 1).copy();
            if (ai[2] > 0 != hasNormals) {
                throw new IllegalArgumentException("Normals are an all or nothing deal here.");
            }
            model.verts[i] = new Vertex5(vert, uv.x, uv.y);
            if (!hasNormals) continue;
            model.normals()[i] = normals.get(ai[2] - 1).copy();
        }
        return model;
    }

    public static void copy(CCModel src, int srcpos, CCModel dst, int destpos, int length) {
        for (int k = 0; k < length; ++k) {
            dst.verts[destpos + k] = src.verts[srcpos + k].copy();
        }
        for (int i = 0; i < src.attributes.size(); ++i) {
            if (src.attributes.get(i) == null) continue;
            AttributeKey key = AttributeKey.AttributeKeyRegistry.getAttributeKey(i);
            dst.allocateAttr(key);
            dst.attributes.set(i, key.copyRange(SneakyUtils.unsafeCast(src.attributes.get(i)), srcpos, SneakyUtils.unsafeCast(dst.getOrAllocate(key)), destpos, length));
        }
    }

    public CCModel apply(Transformation t, int srcpos, int destpos, int length) {
        for (int k = 0; k < length; ++k) {
            this.verts[destpos + k] = this.verts[srcpos + k].copy();
            this.verts[destpos + k].vec.apply(t);
        }
        Vector3[] normals = this.normals();
        if (normals != null) {
            for (int k = 0; k < length; ++k) {
                normals[destpos + k] = normals[srcpos + k].copy();
                t.applyN(normals[destpos + k]);
            }
        }
        return this;
    }

    @Override
    public CCModel copy() {
        CCModel model = CCModel.newModel(this.vertexMode, this.verts.length);
        CCModel.copy(this, 0, model, 0, this.verts.length);
        return model;
    }
}

