/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import ru.auriny.infinitech.client.lib.Copyable;

public abstract class Colour
implements Copyable<Colour> {
    public byte r;
    public byte g;
    public byte b;
    public byte a;

    public Colour(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
    }

    public Colour(Colour colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
    }

    public abstract int pack();

    public Colour add(Colour colour2) {
        this.a = (byte)(this.a + colour2.a);
        this.r = (byte)(this.r + colour2.r);
        this.g = (byte)(this.g + colour2.g);
        this.b = (byte)(this.b + colour2.b);
        return this;
    }

    public Colour multiply(Colour colour2) {
        this.a = (byte)((double)(this.a & 0xFF) * ((double)(colour2.a & 0xFF) / 255.0));
        this.r = (byte)((double)(this.r & 0xFF) * ((double)(colour2.r & 0xFF) / 255.0));
        this.g = (byte)((double)(this.g & 0xFF) * ((double)(colour2.g & 0xFF) / 255.0));
        this.b = (byte)((double)(this.b & 0xFF) * ((double)(colour2.b & 0xFF) / 255.0));
        return this;
    }

    public Colour scale(double d) {
        this.a = (byte)((double)(this.a & 0xFF) * d);
        this.r = (byte)((double)(this.r & 0xFF) * d);
        this.g = (byte)((double)(this.g & 0xFF) * d);
        this.b = (byte)((double)(this.b & 0xFF) * d);
        return this;
    }

    @Override
    public abstract Colour copy();

    public int rgba() {
        return (this.r & 0xFF) << 24 | (this.g & 0xFF) << 16 | (this.b & 0xFF) << 8 | this.a & 0xFF;
    }

    public abstract Colour set(int var1);

    public Colour set(Colour colour) {
        this.r = colour.r;
        this.g = colour.g;
        this.b = colour.b;
        this.a = colour.a;
        return this;
    }

    public Colour set(double r, double g, double b, double a) {
        return this.set((int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b), (int)(255.0 * a));
    }

    public Colour set(float r, float g, float b, float a) {
        return this.set((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a));
    }

    public Colour set(int r, int g, int b, int a) {
        this.r = (byte)r;
        this.g = (byte)g;
        this.b = (byte)b;
        this.a = (byte)a;
        return this;
    }

    public Colour set(double[] doubles) {
        return this.set(doubles[0], doubles[1], doubles[2], doubles[3]);
    }

    public Colour set(float[] floats) {
        return this.set(floats[0], floats[1], floats[2], floats[3]);
    }

    public int r() {
        return this.r & 0xFF;
    }

    public int g() {
        return this.g & 0xFF;
    }

    public int b() {
        return this.b & 0xFF;
    }

    public int a() {
        return this.a & 0xFF;
    }

    public float[] getRGBA() {
        return new float[]{(float)this.r / 255.0f, (float)this.g / 255.0f, (float)this.b / 255.0f, (float)this.a / 255.0f};
    }

    public boolean equals(Colour colour) {
        return colour != null && this.rgba() == colour.rgba();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Colour)) {
            return false;
        }
        Colour colour = (Colour)o;
        if (this.r != colour.r) {
            return false;
        }
        if (this.g != colour.g) {
            return false;
        }
        if (this.b != colour.b) {
            return false;
        }
        return this.a == colour.a;
    }

    public int hashCode() {
        int result = this.r;
        result = 31 * result + this.g;
        result = 31 * result + this.b;
        result = 31 * result + this.a;
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[0x" + Integer.toHexString(this.pack()).toUpperCase() + "]";
    }
}

