/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import ru.auriny.infinitech.client.lib.Copyable;
import ru.auriny.infinitech.client.lib.Transformation;
import ru.auriny.infinitech.client.lib.Vector3;

public class Cuboid6
implements Copyable<Cuboid6> {
    public Vector3 min;
    public Vector3 max;

    public Cuboid6() {
        this(new Vector3(), new Vector3());
    }

    public Cuboid6(Vector3 min, Vector3 max) {
        this.min = min;
        this.max = max;
    }

    public Cuboid6(Cuboid6 cuboid) {
        this.min = cuboid.min.copy();
        this.max = cuboid.max.copy();
    }

    public Cuboid6 set(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.min.set(minx, miny, minz);
        this.max.set(maxx, maxy, maxz);
        return this;
    }

    public Cuboid6 set(Vector3 min, Vector3 max) {
        return this.set(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public Cuboid6 set(Vec3i min, Vec3i max) {
        return this.set(min.m_123341_(), min.m_123342_(), min.m_123343_(), max.m_123341_(), max.m_123342_(), max.m_123343_());
    }

    public Cuboid6 set(Cuboid6 c) {
        return this.set(c.min.x, c.min.y, c.min.z, c.max.x, c.max.y, c.max.z);
    }

    public Cuboid6 set(AABB bb) {
        return this.set(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
    }

    public Cuboid6 add(double dx, double dy, double dz) {
        this.min.add(dx, dy, dz);
        this.max.add(dx, dy, dz);
        return this;
    }

    public Cuboid6 add(double d) {
        return this.add(d, d, d);
    }

    public Cuboid6 add(Vector3 vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Cuboid6 add(Vec3i vec) {
        return this.add(vec.m_123341_(), vec.m_123342_(), vec.m_123343_());
    }

    public Cuboid6 add(BlockPos pos) {
        return this.add(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Cuboid6 offset(Cuboid6 o) {
        this.min.add(o.min);
        this.max.add(o.max);
        return this;
    }

    public boolean contains(double x, double y, double z) {
        return this.min.x - 1.0E-5 <= x && this.min.y - 1.0E-5 <= y && this.min.z - 1.0E-5 <= z && this.max.x + 1.0E-5 >= x && this.max.y + 1.0E-5 >= y && this.max.z + 1.0E-5 >= z;
    }

    public boolean contains(Vector3 vec) {
        return this.contains(vec.x, vec.y, vec.z);
    }

    public int hashCode() {
        int j = Double.hashCode(this.min.x);
        j = 31 * j + Double.hashCode(this.min.y);
        j = 31 * j + Double.hashCode(this.min.z);
        j = 31 * j + Double.hashCode(this.max.x);
        j = 31 * j + Double.hashCode(this.max.y);
        j = 31 * j + Double.hashCode(this.max.z);
        return j;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Cuboid6)) {
            return false;
        }
        Cuboid6 c = (Cuboid6)obj;
        return this.min.equals(c.min) && this.max.equals(c.max);
    }

    @Override
    public Cuboid6 copy() {
        return new Cuboid6(this);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Cuboid: (" + new BigDecimal(this.min.x, cont) + ", " + new BigDecimal(this.min.y, cont) + ", " + new BigDecimal(this.min.z, cont) + ") -> (" + new BigDecimal(this.max.x, cont) + ", " + new BigDecimal(this.max.y, cont) + ", " + new BigDecimal(this.max.z, cont) + ")";
    }

    public Cuboid6 apply(Transformation t) {
        double temp;
        t.apply(this.min);
        t.apply(this.max);
        if (this.min.x > this.max.x) {
            temp = this.min.x;
            this.min.x = this.max.x;
            this.max.x = temp;
        }
        if (this.min.y > this.max.y) {
            temp = this.min.y;
            this.min.y = this.max.y;
            this.max.y = temp;
        }
        if (this.min.z > this.max.z) {
            temp = this.min.z;
            this.min.z = this.max.z;
            this.max.z = temp;
        }
        return this;
    }
}

