/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.client.lib.IOUtils;

public class GlslProcessor {
    private static Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = Boolean.getBoolean("ccl.glsl_processor.debug");
    private static final Pattern VERSION_PATTERN = Pattern.compile("^#version (.*)$");
    private static final Pattern IMPORT_PATTERN = Pattern.compile("^#moj_import (?>(?><(.*)>)|(?>\"(.*)\"))$");
    private final ResourceProvider resourceProvider;
    private final ResourceLocation shader;
    private final Map<ResourceLocation, ProcessorEntry> processorLookup = new HashMap<ResourceLocation, ProcessorEntry>();
    private final LinkedList<ProcessorEntry> newProcessors = new LinkedList();

    public GlslProcessor(ResourceLocation shader) {
        this((ResourceProvider)Minecraft.m_91087_().m_91098_(), shader);
    }

    public GlslProcessor(ResourceProvider resourceProvider, ResourceLocation shader) {
        this.resourceProvider = resourceProvider;
        this.shader = shader;
        this.newProcessors.add(this.processorLookup.computeIfAbsent(shader, x$0 -> new ProcessorEntry((ResourceLocation)x$0)));
    }

    public ProcessedShader process() {
        ProcessorEntry mainEntry = this.newProcessors.peek();
        String mainVersion = Objects.requireNonNull(mainEntry.version, "Main Shader '" + this.shader + "' in chain requires #version.");
        if (mainEntry.includes.isEmpty()) {
            return new ProcessedShader(this.shader, mainEntry.sourceName, List.of(this.shader), String.join((CharSequence)"\n", mainEntry.lines));
        }
        MutableGraph graph = GraphBuilder.directed().build();
        while (!this.newProcessors.isEmpty()) {
            ProcessorEntry entry = this.newProcessors.pop();
            if (entry.version != null && !entry.version.equals(mainVersion)) {
                LOGGER.warn("Shader chain {} -> {} version discrepency. Main Shader: {}, Included Shader: {}. This shader may not compile.", (Object)this.shader, (Object)entry.shader, (Object)mainVersion, (Object)entry.version);
            }
            for (ResourceLocation include : entry.includes) {
                graph.putEdge((Object)include, (Object)entry.shader);
                if (this.processorLookup.containsKey(include)) continue;
                this.newProcessors.add(this.processorLookup.computeIfAbsent(include, x$0 -> new ProcessorEntry((ResourceLocation)x$0)));
            }
        }
        List order = TopologicalSort.topologicalSort((Graph)graph, null);
        LinkedList<Object> outputLines = new LinkedList<Object>();
        outputLines.add("#version " + mainVersion);
        for (ResourceLocation resourceLocation : order) {
            outputLines.add("");
            outputLines.add("/*" + resourceLocation + "*/");
            ProcessorEntry entry = this.processorLookup.get(resourceLocation);
            for (int i = 0; i < entry.lines.size(); ++i) {
                String line = entry.lines.get(i);
                if (entry.linesToComment.contains(i)) {
                    outputLines.add("/*" + line + "*/");
                    continue;
                }
                outputLines.add(line);
            }
        }
        if (DEBUG) {
            Path out = Paths.get("glsl", new String[0]).resolve("assets").resolve(this.shader.m_135827_()).resolve(this.shader.m_135815_());
            try {
                Files.write(IOUtils.makeParents(out), outputLines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write debug glsl output to {}", (Object)out);
            }
        }
        return new ProcessedShader(this.shader, mainEntry.sourceName, List.copyOf(order), String.join((CharSequence)"\n", outputLines));
    }

    private class ProcessorEntry {
        private final ResourceLocation shader;
        private final String sourceName;
        private final List<String> lines;
        private final List<ResourceLocation> includes;
        @Nullable
        private final String version;
        private final IntSet linesToComment;

        private ProcessorEntry(ResourceLocation shader) {
            this.shader = shader;
            try {
                Resource resource = GlslProcessor.this.resourceProvider.m_215593_(shader);
                this.sourceName = resource.m_215506_();
                try (BufferedReader reader = resource.m_215508_();){
                    this.lines = reader.lines().toList();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to read asset '" + shader + "'.", ex);
            }
            this.linesToComment = new IntOpenHashSet();
            this.includes = ProcessorEntry.extractIncludes(this.lines, this.linesToComment);
            this.version = ProcessorEntry.extractVersion(this.lines, this.linesToComment);
        }

        private static List<ResourceLocation> extractIncludes(List<String> lines, IntSet linesToComment) {
            LinkedList<ResourceLocation> imports = new LinkedList<ResourceLocation>();
            for (int i = 0; i < lines.size(); ++i) {
                boolean includeFolder;
                String line = lines.get(i);
                Matcher matcher = IMPORT_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                linesToComment.add(i);
                String match = matcher.group(1);
                boolean bl = includeFolder = match != null;
                if (!includeFolder) {
                    match = matcher.group(2);
                }
                ResourceLocation loc = ResourceLocation.m_135820_((String)match);
                if (includeFolder) {
                    loc = new ResourceLocation(loc.m_135827_(), FilenameUtils.normalize((String)("shaders/include/" + loc.m_135815_()), (boolean)true));
                }
                imports.add(loc);
            }
            return List.copyOf(imports);
        }

        @Nullable
        private static String extractVersion(List<String> lines, IntSet linesToComment) {
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                Matcher matcher = VERSION_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                linesToComment.add(i);
                return matcher.group(1);
            }
            return null;
        }
    }

    public record ProcessedShader(ResourceLocation shader, String sourceName, List<ResourceLocation> order, String processedSource) {
    }
}

