/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import ru.auriny.infinitech.client.lib.AttributeKey;
import ru.auriny.infinitech.client.lib.CCRenderState;
import ru.auriny.infinitech.client.lib.ColourRGBA;
import ru.auriny.infinitech.client.lib.VertexAttribute;

public class LightingAttribute
extends VertexAttribute<int[]> {
    public static final AttributeKey<int[]> attributeKey = AttributeKey.create("lighting", int[]::new);
    private int[] colourRef;

    public LightingAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        if (!(ccrs.computeLighting && ccrs.cFmt.hasColor && ccrs.model.hasAttribute(attributeKey))) {
            return false;
        }
        this.colourRef = ccrs.model.getAttribute(attributeKey);
        if (this.colourRef != null) {
            ccrs.pipeline.addDependency(ccrs.colourAttrib);
            return true;
        }
        return false;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.colour = ColourRGBA.multiply(ccrs.colour, this.colourRef[ccrs.vertexIndex]);
    }
}

