/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import pro.komaru.tridot.util.phys.Vec3;

public class MathUtils {
    public static double[] SIN_TABLE = new double[65536];

    public static float distanceSq(Vec3 vec1, Vec3 vec2) {
        float dx = vec1.x - vec2.x;
        float dy = vec1.y - vec2.y;
        float dz = vec1.z - vec2.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public static float distance(Vec3 vec1, Vec3 vec2) {
        return (float)Math.sqrt(MathUtils.distanceSq(vec1, vec2));
    }

    public static double sin(double d) {
        return SIN_TABLE[(int)((float)d * 10430.378f) & 0xFFFF];
    }

    public static double map(double valueIn, double inMin, double inMax, double outMin, double outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static float map(float valueIn, float inMin, float inMax, float outMin, float outMax) {
        return (valueIn - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
    }

    public static boolean between(double min, double value, double max) {
        return min <= value && value <= max;
    }

    public static int floor(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static int floor(float f) {
        int i = (int)f;
        return f < (float)i ? i - 1 : i;
    }

    public static int ceil(double d) {
        int i = (int)d;
        return d > (double)i ? i + 1 : i;
    }

    public static int ceil(float f) {
        int i = (int)f;
        return f > (float)i ? i + 1 : i;
    }

    public static BlockPos min(Vec3i pos1, Vec3i pos2) {
        return new BlockPos(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()));
    }

    public static BlockPos max(Vec3i pos1, Vec3i pos2) {
        return new BlockPos(Math.max(pos1.m_123341_(), pos2.m_123341_()), Math.max(pos1.m_123342_(), pos2.m_123342_()), Math.max(pos1.m_123343_(), pos2.m_123343_()));
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathUtils.SIN_TABLE[i] = Math.sin((double)i / 65536.0 * 2.0 * Math.PI);
        }
    }
}

