/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import ru.auriny.infinitech.client.lib.AttributeKey;
import ru.auriny.infinitech.client.lib.CCRenderState;
import ru.auriny.infinitech.client.lib.Rotation;
import ru.auriny.infinitech.client.lib.SideAttribute;
import ru.auriny.infinitech.client.lib.Vector3;
import ru.auriny.infinitech.client.lib.VertexAttribute;

public class NormalAttribute
extends VertexAttribute<Vector3[]> {
    public static final AttributeKey<Vector3[]> attributeKey = AttributeKey.create("normal", Vector3[]::new);
    private Vector3[] normalRef;

    public NormalAttribute() {
        super(attributeKey);
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        this.normalRef = ccrs.model.getAttribute(attributeKey);
        if (ccrs.model.hasAttribute(attributeKey)) {
            return this.normalRef != null;
        }
        if (ccrs.model.hasAttribute(SideAttribute.attributeKey)) {
            ccrs.pipeline.addDependency(ccrs.sideAttrib);
            return true;
        }
        throw new IllegalStateException("Normals requested but neither normal or side attrutes are provided by the model");
    }

    @Override
    public void operate(CCRenderState ccrs) {
        if (this.normalRef != null) {
            ccrs.normal.set(this.normalRef[ccrs.vertexIndex]);
        } else {
            ccrs.normal.set(Rotation.axes[ccrs.side]);
        }
    }
}

