/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import ru.auriny.infinitech.client.lib.CCRenderState;
import ru.auriny.infinitech.client.lib.ColourRGBA;
import ru.auriny.infinitech.client.lib.IVertexOperation;
import ru.auriny.infinitech.client.lib.LightModel;

public class PlanarLightModel
implements IVertexOperation {
    public int[] colours;

    public PlanarLightModel(int[] colours) {
        this.colours = colours;
    }

    @Override
    public boolean load(CCRenderState ccrs) {
        if (!ccrs.computeLighting) {
            return false;
        }
        ccrs.pipeline.addDependency(ccrs.sideAttrib);
        ccrs.pipeline.addDependency(ccrs.colourAttrib);
        return true;
    }

    @Override
    public void operate(CCRenderState ccrs) {
        ccrs.colour = ColourRGBA.multiply(ccrs.colour, this.colours[ccrs.side]);
    }

    @Override
    public int operationID() {
        return LightModel.operationIndex;
    }
}

