/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.client.lib.SneakyUtils;

public interface StreamableIterable<T>
extends Iterable<T> {
    public static final StreamableIterable<?> EMPTY = StreamableIterable.of(Collections.emptyList());

    public static <T> StreamableIterable<T> empty() {
        return (StreamableIterable)SneakyUtils.unsafeCast(EMPTY);
    }

    public static <T> StreamableIterable<T> of(Iterable<? extends T> itr) {
        if (itr instanceof StreamableIterable) {
            return (StreamableIterable)itr;
        }
        return itr::iterator;
    }

    public static <T> StreamableIterable<T> of() {
        return (StreamableIterable)SneakyUtils.unsafeCast(EMPTY);
    }

    public static <T> StreamableIterable<T> of(T thing) {
        return StreamableIterable.of(Collections.singletonList(thing));
    }

    public static <T> StreamableIterable<T> of(Optional<? extends T> optional) {
        return optional.map(StreamableIterable::of).orElse(StreamableIterable.empty());
    }

    @SafeVarargs
    public static <T> StreamableIterable<T> of(T ... things) {
        return StreamableIterable.of(Arrays.asList(things));
    }

    default public <R> StreamableIterable<R> map(final Function<? super T, ? extends R> func) {
        return () -> new Iterator<R>(){
            private final Iterator<T> itr;
            {
                this.itr = StreamableIterable.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public R next() {
                return func.apply(this.itr.next());
            }

            @Override
            public void remove() {
                this.itr.remove();
            }
        };
    }

    @Deprecated
    @Nullable
    @Contract(value="!null,_ -> !null")
    @ApiStatus.ScheduledForRemoval(inVersion="0.5.0")
    default public T fold(@Nullable T identity, BinaryOperator<@Nullable T> accumulator) {
        return this.fold((Object)identity, (BiFunction)accumulator);
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    default public <U> U fold(@Nullable U identity, BiFunction<? super @Nullable U, ? super T, ? extends U> accumulator) {
        U ret = identity;
        for (Object t : this) {
            ret = accumulator.apply(ret, t);
        }
        return ret;
    }

    default public int count() {
        int i = 0;
        for (Object ignored : this) {
            ++i;
        }
        return i;
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public ArrayList<T> toList() {
        return Lists.newArrayList((Iterable)this);
    }
}

