/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.client.lib.Copyable;
import ru.auriny.infinitech.client.lib.Matrix4;
import ru.auriny.infinitech.client.lib.StreamableIterable;
import ru.auriny.infinitech.client.lib.Transformation;
import ru.auriny.infinitech.client.lib.Vector3;

public class TransformationList
extends Transformation {
    private ArrayList<Transformation> transformations = new ArrayList();
    @Nullable
    private Matrix4 mat;

    public TransformationList(Transformation ... transforms) {
        this(Arrays.asList(transforms));
    }

    public TransformationList(List<Transformation> transforms) {
        for (Transformation t : transforms) {
            if (t instanceof TransformationList) {
                this.transformations.addAll(((TransformationList)t).transformations);
                continue;
            }
            this.transformations.add(t);
        }
        this.compact();
    }

    public TransformationList(TransformationList other) {
        this.transformations = StreamableIterable.of(other.transformations).map(Copyable::copy).toList();
        this.mat = other.mat;
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            for (int i = this.transformations.size() - 1; i >= 0; --i) {
                this.transformations.get(i).apply(this.mat);
            }
        }
        return this.mat;
    }

    @Override
    public void apply(Vector3 vec) {
        if (this.mat != null) {
            this.mat.apply(vec);
        } else {
            for (Transformation transformation : this.transformations) {
                transformation.apply(vec);
            }
        }
    }

    @Override
    public void applyN(Vector3 normal) {
        if (this.mat != null) {
            this.mat.applyN(normal);
        } else {
            for (Transformation transformation : this.transformations) {
                transformation.applyN(normal);
            }
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.multiply(this.compile());
    }

    @Override
    public TransformationList with(Transformation t) {
        if (t.isRedundant()) {
            return this;
        }
        this.mat = null;
        if (t instanceof TransformationList) {
            this.transformations.addAll(((TransformationList)t).transformations);
        } else {
            this.transformations.add(t);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<Transformation> newList = new ArrayList<Transformation>(this.transformations.size());
        Iterator<Transformation> iterator = this.transformations.iterator();
        Transformation prev = null;
        while (iterator.hasNext()) {
            Transformation t = iterator.next();
            if (t.isRedundant()) continue;
            if (prev != null) {
                Transformation m = prev.merge(t);
                if (m == null) {
                    newList.add(prev);
                } else {
                    t = m.isRedundant() ? null : m;
                }
            }
            prev = t;
        }
        if (prev != null) {
            newList.add(prev);
        }
        if (newList.size() < this.transformations.size()) {
            this.transformations = newList;
            this.mat = null;
        }
        if (this.transformations.size() > 3 && this.mat == null) {
            this.compile();
        }
    }

    @Override
    public boolean isRedundant() {
        return this.transformations.isEmpty();
    }

    @Override
    public Transformation inverse() {
        TransformationList rev = new TransformationList(new Transformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with((Transformation)this.transformations.get(i).inverse());
        }
        return rev;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Transformation t : this.transformations) {
            s.append("\n").append(t.toString());
        }
        return s.toString().trim();
    }

    @Override
    public TransformationList copy() {
        return new TransformationList(this);
    }
}

