/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import ru.auriny.infinitech.client.lib.Matrix4;
import ru.auriny.infinitech.client.lib.Transformation;
import ru.auriny.infinitech.client.lib.Vector3;

public class Translation
extends Transformation {
    public Vector3 vec;

    public Translation(Vector3 vec) {
        this.vec = vec;
    }

    public Translation(double x, double y, double z) {
        this(new Vector3(x, y, z));
    }

    public Translation(Translation trans) {
        this(trans.vec.copy());
    }

    @Override
    public void apply(Vector3 vec) {
        vec.add(this.vec);
    }

    @Override
    public void applyN(Vector3 normal) {
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.translate(this.vec);
    }

    @Override
    public Transformation at(Vector3 point) {
        return this;
    }

    @Override
    public Transformation inverse() {
        return new Translation(-this.vec.x, -this.vec.y, -this.vec.z);
    }

    @Override
    public Transformation merge(Transformation next) {
        if (next instanceof Translation) {
            Translation t = (Translation)next;
            return new Translation(this.vec.copy().add(t.vec));
        }
        return null;
    }

    @Override
    public boolean isRedundant() {
        return this.vec.equalsT(Vector3.ZERO);
    }

    public String toString() {
        MathContext cont = new MathContext(4, RoundingMode.HALF_UP);
        return "Translation(" + new BigDecimal(this.vec.x, cont) + ", " + new BigDecimal(this.vec.y, cont) + ", " + new BigDecimal(this.vec.z, cont) + ")";
    }

    @Override
    public Translation copy() {
        return new Translation(this);
    }
}

