/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.lib;

import java.util.ArrayList;
import ru.auriny.infinitech.client.lib.Copyable;
import ru.auriny.infinitech.client.lib.StreamableIterable;
import ru.auriny.infinitech.client.lib.UV;
import ru.auriny.infinitech.client.lib.UVTransformation;

public class UVTransformationList
extends UVTransformation {
    private ArrayList<UVTransformation> transformations = new ArrayList();

    public UVTransformationList(UVTransformation ... transforms) {
        for (UVTransformation t : transforms) {
            if (t instanceof UVTransformationList) {
                this.transformations.addAll(((UVTransformationList)t).transformations);
                continue;
            }
            this.transformations.add(t);
        }
        this.compact();
    }

    public UVTransformationList(UVTransformationList other) {
        this.transformations = StreamableIterable.of(other.transformations).map(Copyable::copy).toList();
        this.compact();
    }

    @Override
    public void apply(UV uv) {
        for (UVTransformation transformation : this.transformations) {
            transformation.apply(uv);
        }
    }

    @Override
    public UVTransformationList with(UVTransformation t) {
        if (t.isRedundant()) {
            return this;
        }
        if (t instanceof UVTransformationList) {
            this.transformations.addAll(((UVTransformationList)t).transformations);
        } else {
            this.transformations.add(t);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<UVTransformation> newList = new ArrayList<UVTransformation>(this.transformations.size());
        UVTransformation prev = null;
        for (UVTransformation t : this.transformations) {
            if (t.isRedundant()) continue;
            if (prev != null) {
                UVTransformation m = prev.merge(t);
                if (m == null) {
                    newList.add(prev);
                } else {
                    t = m.isRedundant() ? null : m;
                }
            }
            prev = t;
        }
        if (prev != null) {
            newList.add(prev);
        }
        if (newList.size() < this.transformations.size()) {
            this.transformations = newList;
        }
    }

    @Override
    public boolean isRedundant() {
        return this.transformations.isEmpty();
    }

    @Override
    public UVTransformation inverse() {
        UVTransformationList rev = new UVTransformationList(new UVTransformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with((UVTransformation)this.transformations.get(i).inverse());
        }
        return rev;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (UVTransformation t : this.transformations) {
            s.append("\n").append(t.toString());
        }
        return s.toString().trim();
    }

    @Override
    public UVTransformation copy() {
        return new UVTransformationList(this);
    }
}

