/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.InfiniTech;
import ru.auriny.infinitech.client.InfinitechShaders;
import ru.auriny.infinitech.client.lib.PerspectiveModelState;
import ru.auriny.infinitech.client.model.IItemRenderer;
import ru.auriny.infinitech.client.model.WrappedItemModel;

public class CosmicBakedModel
extends WrappedItemModel
implements IItemRenderer {
    private final List<ResourceLocation> maskSprite;

    public CosmicBakedModel(BakedModel wrapped, List<ResourceLocation> maskSprite) {
        super(wrapped);
        this.maskSprite = maskSprite;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int light, int overlay) {
        this.renderWrapped(stack, pStack, source, light, overlay, true);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.m_109911_();
        }
        Minecraft mc = Minecraft.m_91087_();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (InfinitechShaders.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(mc.f_91074_.m_146908_() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.f_91074_.m_146909_() * 2.0f) * Math.PI / 360.0));
        }
        InfinitechShaders.cosmicTime.m_5985_((float)(System.currentTimeMillis() - (long)InfinitechShaders.renderTime) / 2000.0f);
        InfinitechShaders.cosmicYaw.m_5985_(yaw);
        InfinitechShaders.cosmicPitch.m_5985_(pitch);
        InfinitechShaders.cosmicExternalScale.m_5985_(scale);
        InfinitechShaders.cosmicOpacity.m_5985_(1.0f);
        for (int i = 0; i < 10; ++i) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(InfiniTech.rl("shader/cosmic_" + i));
            InfinitechShaders.COSMIC_UVS[i * 4] = sprite.m_118409_();
            InfinitechShaders.COSMIC_UVS[i * 4 + 1] = sprite.m_118411_();
            InfinitechShaders.COSMIC_UVS[i * 4 + 2] = sprite.m_118410_();
            InfinitechShaders.COSMIC_UVS[i * 4 + 3] = sprite.m_118412_();
        }
        if (InfinitechShaders.cosmicUVs != null) {
            InfinitechShaders.cosmicUVs.m_5941_(InfinitechShaders.COSMIC_UVS);
        }
        VertexConsumer cons = source.m_6299_(InfinitechShaders.COSMIC_RENDER_TYPE);
        BakedModel model = this.wrapped.m_7343_().m_173464_(this.wrapped, stack, this.world, this.entity, 0);
        if (model != null && model.m_7539_() && stack.m_41720_() instanceof BlockItem) {
            ArrayList blockLayer = new ArrayList();
            RandomSource random = RandomSource.m_216327_();
            for (Direction direction : Direction.values()) {
                blockLayer.addAll(model.m_213637_(null, direction, random));
            }
            ArrayList<TextureAtlasSprite> maskSprites = new ArrayList<TextureAtlasSprite>();
            for (ResourceLocation res : this.maskSprite) {
                maskSprites.add((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(res));
            }
            ArrayList<BakedQuad> overlayQuads = new ArrayList<BakedQuad>();
            for (BakedQuad base : blockLayer) {
                for (TextureAtlasSprite sprite : maskSprites) {
                    BakedQuad masked = new BakedQuad(base.m_111303_(), base.m_111305_(), base.m_111306_(), sprite, base.m_111307_());
                    overlayQuads.add(masked);
                }
            }
            mc.m_91291_().m_115162_(pStack, cons, overlayQuads, stack, light, overlay);
        } else {
            ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
            for (ResourceLocation res : this.maskSprite) {
                atlasSprite.add((TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(res));
            }
            mc.m_91291_().m_115162_(pStack, cons, CosmicBakedModel.bakeItem(atlasSprite), stack, light, overlay);
        }
    }

    @Override
    @Nullable
    public PerspectiveModelState getModelState() {
        return (PerspectiveModelState)this.parentState;
    }

    @Override
    public boolean isCosmic() {
        return true;
    }

    @Override
    public boolean m_7541_() {
        return this.wrapped.m_7541_();
    }

    @Override
    public boolean m_7539_() {
        return this.wrapped.m_7539_();
    }

    @Override
    public boolean m_7547_() {
        return this.wrapped.m_7547_();
    }
}

