/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.apache.commons.lang3.tuple.Pair;
import ru.auriny.infinitech.client.lib.CachedFormat;
import ru.auriny.infinitech.client.lib.IVertexConsumer;
import ru.auriny.infinitech.client.lib.Quad;
import ru.auriny.infinitech.client.lib.VertexUtils;
import ru.auriny.infinitech.client.model.HaloBakedModel;

@OnlyIn(value=Dist.CLIENT)
public class HaloItemModelLoader
implements IGeometryLoader<HaloItemModelGeometry> {
    public static final HaloItemModelLoader INSTANCE = new HaloItemModelLoader();

    public HaloItemModelGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonObject halo = modelContents.getAsJsonObject("halo");
        if (halo == null) {
            throw new IllegalStateException("Missing 'halo' object.");
        }
        IntArrayList layerColors = new IntArrayList();
        JsonArray layerColorsArr = modelContents.getAsJsonArray("layerColors");
        if (layerColorsArr != null) {
            for (JsonElement jsonElement : layerColorsArr) {
                layerColors.add(jsonElement.getAsInt());
            }
        }
        String texture = GsonHelper.m_13906_((JsonObject)halo, (String)"texture");
        int color = GsonHelper.m_13927_((JsonObject)halo, (String)"color");
        int size = GsonHelper.m_13927_((JsonObject)halo, (String)"size");
        boolean pulse = GsonHelper.m_13912_((JsonObject)halo, (String)"pulse");
        JsonObject clean = modelContents.getAsJsonObject();
        clean.remove("halo");
        clean.remove("loader");
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)clean, BlockModel.class);
        return new HaloItemModelGeometry(baseModel, (IntList)layerColors, texture, color, size, pulse);
    }

    public static class HaloItemModelGeometry
    implements IUnbakedGeometry<HaloItemModelGeometry> {
        private static final ConcurrentMap<Pair<VertexFormat, VertexFormat>, int[]> formatMaps = new ConcurrentHashMap<Pair<VertexFormat, VertexFormat>, int[]>();
        private static final int[] DEFAULT_MAPPING = HaloItemModelGeometry.generateMapping(DefaultVertexFormat.f_85811_, DefaultVertexFormat.f_85811_);
        private final BlockModel baseModel;
        private final IntList layerColors;
        private final String texture;
        private final int color;
        private final int size;
        private final boolean pulse;

        public HaloItemModelGeometry(BlockModel baseModel, IntList layerColors, String texture, int color, int size, boolean pulse) {
            this.baseModel = baseModel;
            this.layerColors = layerColors;
            this.texture = texture;
            this.color = color;
            this.size = size;
            this.pulse = pulse;
        }

        private static BakedModel tintLayers(BakedModel model, IntList layerColors) {
            Direction[] var3;
            if (layerColors.isEmpty()) {
                return model;
            }
            HashMap<Direction, List<BakedQuad>> faceQuads = new HashMap<Direction, List<BakedQuad>>();
            for (Direction face : var3 = Direction.values()) {
                faceQuads.put(face, HaloItemModelGeometry.transformQuads(model.m_213637_(null, face, RandomSource.m_216327_()), layerColors));
            }
            List<BakedQuad> unculled = HaloItemModelGeometry.transformQuads(model.m_213637_(null, null, RandomSource.m_216327_()), layerColors);
            return new SimpleBakedModel(unculled, faceQuads, model.m_7541_(), model.m_7547_(), model.m_7539_(), model.m_6160_(), model.m_7442_(), ItemOverrides.f_111734_);
        }

        static List<BakedQuad> transformQuads(List<BakedQuad> quads, IntList layerColors) {
            ArrayList<BakedQuad> newQuads = new ArrayList<BakedQuad>(quads.size());
            for (BakedQuad quad : quads) {
                newQuads.add(HaloItemModelGeometry.transformQuad(quad, layerColors));
            }
            return newQuads;
        }

        public static int[] mapFormats(VertexFormat from, VertexFormat to) {
            return from.equals((Object)DefaultVertexFormat.f_85811_) && to.equals((Object)DefaultVertexFormat.f_85811_) ? DEFAULT_MAPPING : formatMaps.computeIfAbsent((Pair<VertexFormat, VertexFormat>)Pair.of((Object)from, (Object)to), pair -> HaloItemModelGeometry.generateMapping((VertexFormat)pair.getLeft(), (VertexFormat)pair.getRight()));
        }

        public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
            VertexUtils.unpack(from, to, formatFrom, v, e);
        }

        private static int[] generateMapping(VertexFormat from, VertexFormat to) {
            int fromCount = from.m_86023_().size();
            int toCount = to.m_86023_().size();
            int[] eMap = new int[fromCount];
            for (int e = 0; e < fromCount; ++e) {
                int e2;
                VertexFormatElement expected = (VertexFormatElement)from.m_86023_().get(e);
                for (e2 = 0; e2 < toCount; ++e2) {
                    VertexFormatElement current = (VertexFormatElement)to.m_86023_().get(e2);
                    if (expected.m_86048_() == current.m_86048_() && expected.m_86049_() == current.m_86049_()) break;
                }
                eMap[e] = e2;
            }
            return eMap;
        }

        public static void putBakedQuad(IVertexConsumer consumer, BakedQuad quad) {
            consumer.setTexture(quad.m_173410_());
            consumer.setQuadOrientation(quad.m_111306_());
            if (quad.m_111304_()) {
                consumer.setQuadTint(quad.m_111305_());
            }
            consumer.setApplyDiffuseLighting(quad.m_111307_());
            float[] data = new float[4];
            VertexFormat formatFrom = consumer.getVertexFormat();
            VertexFormat formatTo = DefaultVertexFormat.f_85811_;
            int countFrom = formatFrom.m_86023_().size();
            int countTo = formatTo.m_86023_().size();
            int[] eMap = HaloItemModelGeometry.mapFormats(formatFrom, formatTo);
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < countFrom; ++e) {
                    if (eMap[e] != countTo) {
                        HaloItemModelGeometry.unpack(quad.m_111303_(), data, formatTo, v, eMap[e]);
                        consumer.put(e, data);
                        continue;
                    }
                    consumer.put(e, new float[0]);
                }
            }
        }

        static BakedQuad transformQuad(BakedQuad quad, IntList layerColors) {
            int tintIndex = quad.m_111305_();
            if (tintIndex != -1 && tintIndex < layerColors.size()) {
                Quad.Vertex[] var8;
                int tint = layerColors.getInt(tintIndex);
                if (tint == -1) {
                    return quad;
                }
                Quad newQuad = new Quad();
                newQuad.reset(CachedFormat.BLOCK);
                HaloItemModelGeometry.putBakedQuad(newQuad, quad);
                float r = (float)(tint >> 16 & 0xFF) / 255.0f;
                float g = (float)(tint >> 8 & 0xFF) / 255.0f;
                float b = (float)(tint & 0xFF) / 255.0f;
                for (Quad.Vertex v : var8 = newQuad.vertices) {
                    float[] var10000 = v.color;
                    var10000[0] = var10000[0] * r;
                    var10000[1] = var10000[1] * g;
                    var10000[2] = var10000[2] * b;
                }
                newQuad.tintIndex = -1;
                return newQuad.bake();
            }
            return quad;
        }

        public BakedModel bake(IGeometryBakingContext owner, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel bakedBaseModel = this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelTransform, modelLocation, false);
            Material particleLocation = this.baseModel.m_111480_(this.texture);
            TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
            return new HaloBakedModel(HaloItemModelGeometry.tintLayers(bakedBaseModel, this.layerColors), particle, this.color, this.size, this.pulse);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.baseModel.m_5500_(modelGetter);
        }
    }
}

