/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Transformation;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import ru.auriny.infinitech.InfiniTech;
import ru.auriny.infinitech.client.lib.PerspectiveModel;
import ru.auriny.infinitech.client.lib.PerspectiveModelState;
import ru.auriny.infinitech.client.lib.TransformUtils;

public abstract class WrappedItemModel
implements PerspectiveModel {
    protected BakedModel wrapped;
    protected ModelState parentState;
    @Nullable
    protected LivingEntity entity;
    @Nullable
    protected ClientLevel world;
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    protected ItemOverrides overrideList = new ItemOverrides(){

        public BakedModel m_173464_(@NotNull BakedModel originalModel, @NotNull ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
            WrappedItemModel.this.entity = entity;
            ClientLevel clientLevel = world == null ? (entity == null ? null : (ClientLevel)entity.m_9236_()) : (WrappedItemModel.this.world = null);
            if (WrappedItemModel.this.isCosmic()) {
                return WrappedItemModel.this.wrapped.m_7343_().m_173464_(originalModel, stack, world, entity, seed);
            }
            return originalModel;
        }
    };

    public WrappedItemModel(BakedModel wrapped) {
        this.wrapped = wrapped;
        this.parentState = TransformUtils.stateFromItemTransforms(wrapped.m_7442_());
    }

    public static List<BakedQuad> bakeItem(List<TextureAtlasSprite> sprites) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        for (TextureAtlasSprite sprite : sprites) {
            List unbaked = ITEM_MODEL_GENERATOR.m_111638_(sprites.indexOf(sprite), "layer" + sprites.indexOf(sprite), sprite.m_245424_());
            for (BlockElement element : unbaked) {
                for (Map.Entry entry : element.f_111310_.entrySet()) {
                    quads.add(FACE_BAKERY.m_111600_(element.f_111308_, element.f_111309_, (BlockElementFace)entry.getValue(), sprite, (Direction)entry.getKey(), (ModelState)new PerspectiveModelState((Map<ItemDisplayContext, Transformation>)ImmutableMap.of()), element.f_111311_, element.f_111312_, InfiniTech.rl("dynamic")));
                }
            }
        }
        return quads;
    }

    public boolean isCosmic() {
        return false;
    }

    @NotNull
    public List<BakedQuad> m_213637_(BlockState state, Direction side, @NotNull RandomSource rand) {
        return Collections.emptyList();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.wrapped.m_6160_();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        return this.wrapped.getParticleIcon(data);
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return this.overrideList;
    }

    public boolean m_7541_() {
        return this.wrapped.m_7541_();
    }

    public boolean m_7539_() {
        return this.wrapped.m_7539_();
    }

    public boolean m_7547_() {
        return this.wrapped.m_7547_();
    }

    protected void renderWrapped(ItemStack stack, PoseStack pStack, MultiBufferSource buffers, int packedLight, int packedOverlay, boolean fabulous) {
        this.renderWrapped(stack, pStack, buffers, packedLight, packedOverlay, fabulous, Function.identity());
    }

    protected void renderWrapped(ItemStack stack, PoseStack pStack, MultiBufferSource buffers, int packedLight, int packedOverlay, boolean fabulous, Function<VertexConsumer, VertexConsumer> consOverride) {
        BakedModel model = this.wrapped.m_7343_().m_173464_(this.wrapped, stack, this.world, this.entity, 0);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        for (BakedModel bakedModel : model.getRenderPasses(stack, true)) {
            for (RenderType rendertype : bakedModel.getRenderTypes(stack, true)) {
                itemRenderer.m_115189_(bakedModel, stack, packedLight, packedOverlay, pStack, consOverride.apply(buffers.m_6299_(rendertype)));
            }
        }
    }
}

