/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.gfx.lightningBolt.LightningInstance;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.phys.Vec3;
import ru.auriny.infinitech.registries.block.tile.InjectorCoreTile;

public class InjectorCoreTileRenderer
implements BlockEntityRenderer<InjectorCoreTile> {
    private final Map<BlockPos, LightningInstance> lightningMap = new HashMap<BlockPos, LightningInstance>();
    private static final Col LIGHTNING_COLOR = new Col(0.2f, 0.5f, 0.7f, 1.0f);

    public InjectorCoreTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(InjectorCoreTile te, float partialTicks, PoseStack mStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        long gameTime = ClientTick.ticksInGame;
        ItemStack output = te.getItemHandler().m_8020_(0);
        if (!output.m_41619_()) {
            int light = LevelRenderer.m_109541_((BlockAndTintGetter)te.m_58904_(), (BlockPos)te.m_58899_().m_7494_());
            mStack.m_85836_();
            mStack.m_85837_(0.5, 1.25 + Math.sin((double)gameTime / 20.0) * 0.1, 0.5);
            mStack.m_252781_(Axis.f_252436_.m_252977_((float)(gameTime * 2L)));
            mStack.m_85841_(0.5f, 0.5f, 0.5f);
            Minecraft.m_91087_().m_91291_().m_269128_(output, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, mStack, buffer, (Level)Minecraft.m_91087_().f_91073_, 0);
            mStack.m_85849_();
        }
        if (!Minecraft.m_91087_().m_91104_()) {
            this.updateVisuals(te, mStack, buffer);
        }
    }

    private void updateVisuals(InjectorCoreTile te, PoseStack mStack, MultiBufferSource buffer) {
        mStack.m_85836_();
        mStack.m_85837_(0.5, 0.5, 0.5);
        this.updateLightnings(te, mStack, buffer);
        if (te.isCrafting() && te.maxProgress > 0) {
            this.createLightning(te);
        }
        mStack.m_85849_();
    }

    private void updateLightnings(InjectorCoreTile te, PoseStack mStack, MultiBufferSource buffer) {
        Iterator<Map.Entry<BlockPos, LightningInstance>> it = this.lightningMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, LightningInstance> entry = it.next();
            LightningInstance bolt = entry.getValue();
            bolt.tick();
            if (bolt.age >= bolt.getLifetime()) {
                it.remove();
                continue;
            }
            if ((double)te.progress > (double)te.maxProgress * 0.8) {
                bolt.builder.setScaleModifier(0.25f);
            }
            bolt.renderTick(mStack, buffer);
        }
    }

    public void createLightning(InjectorCoreTile te) {
        for (BlockPos injectorPos : te.getConnectedInjectorsPos()) {
            LightningInstance bolt = this.lightningMap.get(injectorPos);
            if (bolt != null && bolt.age < bolt.getLifetime()) continue;
            this.lightningMap.remove(injectorPos);
            if (!Tmp.rnd.chance(0.015)) continue;
            double dx = injectorPos.m_123341_() - te.m_58899_().m_123341_();
            double dy = injectorPos.m_123342_() - te.m_58899_().m_123342_();
            double dz = injectorPos.m_123343_() - te.m_58899_().m_123343_();
            this.lightningMap.put(injectorPos.m_7918_(Tmp.rnd.nextInt(), Tmp.rnd.nextInt(), Tmp.rnd.nextInt()), new LightningInstance.LightningBuilder().setColor(LIGHTNING_COLOR).setScaleModifier(0.125f).setLifetime(6 + Tmp.rnd.nextInt(10)).build(Vec3.zero(), new Vec3(dx, dy, dz)));
        }
    }
}

