/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import ru.auriny.infinitech.core.menu.NeutroniumHarvesterMenu;
import ru.auriny.infinitech.core.util.NumberFormatter;
import ru.auriny.infinitech.registries.block.tile.NeutroniumHarvesterTile;

@OnlyIn(value=Dist.CLIENT)
public class NeutroniumHarvesterScreen
extends AbstractContainerScreen<NeutroniumHarvesterMenu> {
    public ArcRandom random = Tmp.rnd;
    private final ResourceLocation BG_LOCATION = new ResourceLocation("infinitech", "textures/gui/neutronium_harvester.png");

    public NeutroniumHarvesterScreen(NeutroniumHarvesterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97731_ += 46;
    }

    public void m_88315_(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.m_280072_(gui, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ + 50, this.f_97729_, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ - 45, 0x404040, false);
        BlockEntity blockEntity = ((NeutroniumHarvesterMenu)this.f_97732_).blockEntity;
        if (blockEntity instanceof NeutroniumHarvesterTile) {
            NeutroniumHarvesterTile solar = (NeutroniumHarvesterTile)blockEntity;
            pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("\u0401\u043c\u043a\u043e\u0441\u0442\u044c: %s FE", NumberFormatter.formatNumber(solar.getMaxEnergyStored()))).m_130940_(ChatFormatting.GREEN), this.f_97730_ + 32, 25, TextColor.m_131266_((int)Color.WHITE.getRGB()).m_131265_(), true);
            pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("\u041f\u043e\u0442\u0440\u0435\u0431\u043b\u0435\u043d\u0438\u0435: %s FE", NumberFormatter.formatNumber(solar.getCurrentRecipe().isPresent() ? solar.getCurrentRecipe().get().getEnergy() : 0))).m_130940_(ChatFormatting.DARK_GREEN), this.f_97730_ + 32, 36, TextColor.m_131266_((int)Color.WHITE.getRGB()).m_131265_(), true);
        }
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        BlockEntity blockEntity = ((NeutroniumHarvesterMenu)this.f_97732_).blockEntity;
        if (blockEntity instanceof NeutroniumHarvesterTile) {
            NeutroniumHarvesterTile solar = (NeutroniumHarvesterTile)blockEntity;
            int i = this.f_97735_;
            int j = this.f_97736_;
            if (pX >= i + 7 && pX < i + 7 + 163 && pY >= j + 53 && pY < j + 53 + 9) {
                pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)("\u26a1 " + NumberFormatter.formatNumber(solar.getEnergyStored()) + " FE")).m_130940_(ChatFormatting.AQUA), pX, pY);
            }
            if (pX >= i + 39 && pX < i + 39 + 128 && pY >= j + 14 && pY < j + 14 + 9) {
                int progress = 100;
                progress = (int)((double)progress / ((double)solar.getMaxProgress() / (double)solar.getProgress()));
                pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)("\u041f\u0440\u043e\u0433\u0440\u0435\u0441\u0441 - " + NumberFormatter.formatNumber(progress) + " / 100%")).m_130940_(ChatFormatting.DARK_GREEN), pX, pY);
            }
        }
    }

    public SoundEvent getRandomSound() {
        if (this.random.chance(5)) {
            return SoundEvents.f_11792_;
        }
        if (this.random.chance(35)) {
            return SoundEvents.f_11793_;
        }
        return SoundEvents.f_11785_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Minecraft mc = Minecraft.m_91087_();
            int i = this.f_97735_;
            int j = this.f_97736_;
            if (mouseX >= (double)(i + 83) && mouseX < (double)(i + 83 + 11) && mouseY >= (double)(j + 64) && mouseY < (double)(j + 64 + 11) && mc.f_91074_ != null) {
                mc.f_91074_.m_6330_(this.getRandomSound(), SoundSource.NEUTRAL, 1.0f, this.random.nextFloat(0.9f, 1.1f));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int x, int y) {
        this.m_280273_(gui);
        int i = this.f_97735_;
        int j = this.f_97736_;
        gui.m_280218_(this.BG_LOCATION, i, j - 24, 0, 0, 244, 200);
        BlockEntity blockEntity = ((NeutroniumHarvesterMenu)this.f_97732_).blockEntity;
        if (blockEntity instanceof NeutroniumHarvesterTile) {
            NeutroniumHarvesterTile solar = (NeutroniumHarvesterTile)blockEntity;
            if (solar.getEnergyStored() > 0) {
                int width = 163;
                width = (int)((double)width / ((double)solar.getMaxEnergyStored() / (double)solar.getEnergyStored()));
                float pulse = (float)(1.0 + 0.035 * Math.sin(System.currentTimeMillis() / 250L));
                RenderSystem.setShaderColor((float)pulse, (float)pulse, (float)pulse, (float)1.0f);
                gui.m_280163_(this.BG_LOCATION, i + 7, j + 53, 0.0f, 247.0f, width, 9, 256, 256);
            }
            if (solar.getProgress() > 0) {
                int width = 128;
                width = (int)((double)width / ((double)solar.getMaxProgress() / (double)solar.getProgress()));
                gui.m_280163_(this.BG_LOCATION, i + 39, j + 14, 0.0f, 232.0f, width, 9, 256, 256);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

