/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import ru.auriny.infinitech.core.menu.SolarPanelMenu;
import ru.auriny.infinitech.core.util.NumberFormatter;
import ru.auriny.infinitech.registries.block.tile.SolarPanelTile;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

@OnlyIn(value=Dist.CLIENT)
@GradleSideOnly(value={GradleSide.CLIENT})
public class SolarPanelScreen
extends AbstractContainerScreen<SolarPanelMenu> {
    public ArcRandom random = Tmp.rnd;
    private final ResourceLocation BG_LOCATION = new ResourceLocation("infinitech", "textures/gui/solar_panel.png");

    public SolarPanelScreen(SolarPanelMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97731_ += 46;
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(gui);
        super.m_88315_(gui, mouseX, mouseY, partialTicks);
        this.m_280072_(gui, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ + 50, this.f_97729_ - 2, 0x404040, false);
        pGuiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_ - 45, 0x404040, false);
        BlockEntity blockEntity = ((SolarPanelMenu)this.f_97732_).blockEntity;
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile solar = (SolarPanelTile)blockEntity;
            pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("\u0412\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c: %s FE", NumberFormatter.formatNumber(solar.getMaxEnergyStored()))).m_130940_(ChatFormatting.GREEN), this.f_97730_ + 3, 6, TextColor.m_131266_((int)Color.WHITE.getRGB()).m_131265_(), true);
            pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430: %s FE/\u0442\u0438\u043a", NumberFormatter.formatNumber(solar.rfTransfer))).m_130940_(ChatFormatting.GOLD), this.f_97730_ + 3, 16, TextColor.m_131266_((int)Color.WHITE.getRGB()).m_131265_(), true);
            pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format("\u0412\u044b\u0440\u0430\u0431\u043e\u0442\u043a\u0430: %s FE/\u0442\u0438\u043a", NumberFormatter.formatNumber(solar.getProduction()))), this.f_97730_ + 3, 26, TextColor.m_131266_((int)Color.WHITE.getRGB()).m_131265_(), true);
            pGuiGraphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.format(" - \u0414\u043d\u0451\u043c: %s", NumberFormatter.formatNumber(solar.day) + "% | ")).m_130946_(String.format("\u041d\u043e\u0447\u044c\u044e: %s%%", NumberFormatter.formatNumber(solar.night))).m_130940_(ChatFormatting.GRAY), this.f_97730_ + 3, 36, TextColor.m_131266_((int)Color.WHITE.getRGB()).m_131265_(), true);
        }
    }

    protected void m_280072_(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.m_280072_(pGuiGraphics, pX, pY);
        BlockEntity blockEntity = ((SolarPanelMenu)this.f_97732_).blockEntity;
        if (blockEntity instanceof SolarPanelTile) {
            SolarPanelTile solar = (SolarPanelTile)blockEntity;
            int i = this.f_97735_;
            int j = this.f_97736_;
            if (pX >= i + 7 && pX < i + 7 + 163 && pY >= j + 53 && pY < j + 53 + 9) {
                pGuiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237113_((String)("\u26a1 " + NumberFormatter.formatNumber(solar.getEnergyStored()) + " FE")).m_130940_(ChatFormatting.AQUA), pX, pY);
            }
        }
    }

    public SoundEvent getRandomSound() {
        if (this.random.chance(5)) {
            return SoundEvents.f_11792_;
        }
        if (this.random.chance(35)) {
            return SoundEvents.f_11793_;
        }
        return SoundEvents.f_11785_;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            Minecraft mc = Minecraft.m_91087_();
            int i = this.f_97735_;
            int j = this.f_97736_;
            if (mouseX >= (double)(i + 83) && mouseX < (double)(i + 83 + 11) && mouseY >= (double)(j + 62) && mouseY < (double)(j + 62 + 11) && mc.f_91074_ != null) {
                mc.f_91074_.m_6330_(this.getRandomSound(), SoundSource.NEUTRAL, 1.0f, this.random.nextFloat(0.9f, 1.1f));
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_7286_(GuiGraphics gui, float partialTicks, int x, int y) {
        SolarPanelTile solar;
        this.m_280273_(gui);
        int i = this.f_97735_;
        int j = this.f_97736_;
        gui.m_280218_(this.BG_LOCATION, i - 68, j - 26, 0, 0, 244, 200);
        BlockEntity blockEntity = ((SolarPanelMenu)this.f_97732_).blockEntity;
        if (blockEntity instanceof SolarPanelTile && (solar = (SolarPanelTile)blockEntity).getEnergyStored() > 0) {
            int width = 163;
            width = (int)((double)width / ((double)solar.getMaxEnergyStored() / (double)solar.getEnergyStored()));
            float pulse = (float)(1.0 + 0.035 * Math.sin(System.currentTimeMillis() / 250L));
            RenderSystem.setShaderColor((float)pulse, (float)pulse, (float)pulse, (float)1.0f);
            gui.m_280163_(this.BG_LOCATION, i + 7, j + 53, 0.0f, 247.0f, width, 9, 256, 256);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

