/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import ru.auriny.infinitech.client.screen.ExtremeCraftingScreen;
import ru.auriny.infinitech.core.compat.jei.ModJeiRecipes;
import ru.auriny.infinitech.core.compat.jei.ModRecipeTypes;
import ru.auriny.infinitech.core.compat.jei.categories.ExtremeCraftingRecipeCategory;
import ru.auriny.infinitech.core.compat.jei.categories.HarvesterRecipeCategory;
import ru.auriny.infinitech.registries.BlockRegistry;

@JeiPlugin
public class ModJeiPlugin
implements IModPlugin {
    private static final ResourceLocation JEI = new ResourceLocation("infinitech", "jei_plugin");

    public ResourceLocation getPluginUid() {
        return JEI;
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(ExtremeCraftingScreen.class, 178, 8, 12, 12, new RecipeType[]{ModRecipeTypes.EXTREME_CRAFTING});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new HarvesterRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ExtremeCraftingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ModJeiRecipes modRecipes = new ModJeiRecipes(registration.getIngredientManager());
        registration.addRecipes(ModRecipeTypes.HARVESTER, modRecipes.getHarvesterRecipes());
        registration.addRecipes(ModRecipeTypes.EXTREME_CRAFTING, modRecipes.getExtremeRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.extremeCraftingTable.get()), new RecipeType[]{ModRecipeTypes.EXTREME_CRAFTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.neutroniumHarvester_1.get()), new RecipeType[]{ModRecipeTypes.HARVESTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.neutroniumHarvester_2.get()), new RecipeType[]{ModRecipeTypes.HARVESTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.neutroniumHarvester_3.get()), new RecipeType[]{ModRecipeTypes.HARVESTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.neutroniumHarvester_4.get()), new RecipeType[]{ModRecipeTypes.HARVESTER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.neutroniumHarvester_5.get()), new RecipeType[]{ModRecipeTypes.HARVESTER});
    }
}

