/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.compat.jei.categories;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ru.auriny.infinitech.core.compat.jei.ModRecipeTypes;
import ru.auriny.infinitech.core.recipes.BaseTableCraftingRecipe;
import ru.auriny.infinitech.core.recipes.ShapedTableCraftingRecipe;
import ru.auriny.infinitech.core.recipes.ShapelessTableCraftingRecipe;
import ru.auriny.infinitech.registries.BlockRegistry;

public class ExtremeCraftingRecipeCategory
extends AbstractRecipeCategory<BaseTableCraftingRecipe> {
    private final IDrawable background;

    public ExtremeCraftingRecipeCategory(IGuiHelper helper) {
        super(ModRecipeTypes.EXTREME_CRAFTING, (Component)Component.m_237113_((String)"\u042d\u043a\u0441\u0442\u0440\u0435\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0432\u0435\u0440\u0441\u0442\u0430\u043a"), helper.createDrawableItemLike((ItemLike)BlockRegistry.extremeCraftingTable.get()), 190, 164);
        ResourceLocation backgroundImage = new ResourceLocation("infinitech", "textures/gui/jei/extreme.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 190, 164);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BaseTableCraftingRecipe recipe, IFocusGroup focusGroup) {
        NonNullList inputs = recipe.m_7527_();
        ItemStack output = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        if (recipe instanceof ShapedTableCraftingRecipe) {
            ShapedTableCraftingRecipe shaped = (ShapedTableCraftingRecipe)recipe;
            int stackIndex = 0;
            int heightOffset = Math.floorDiv(shaped.getHeight(), 2);
            int widthOffset = Math.floorDiv(shaped.getWidth(), 2);
            for (int i = heightOffset; i < shaped.getHeight() + heightOffset; ++i) {
                for (int j = widthOffset; j < shaped.getWidth() + widthOffset; ++j) {
                    builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients((Ingredient)inputs.get(stackIndex));
                    ++stackIndex;
                }
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 168, 73).addItemStack(output);
        } else if (recipe instanceof ShapelessTableCraftingRecipe) {
            this.shapelessRecipe(builder, (NonNullList<Ingredient>)inputs);
            builder.addSlot(RecipeIngredientRole.OUTPUT, 164, 70).addItemStack(output);
        }
    }

    private void shapelessRecipe(@NotNull IRecipeLayoutBuilder builder, NonNullList<Ingredient> inputs) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                int index = j + i * 9;
                if (index >= inputs.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, j * 18 + 2, i * 18 + 2).addIngredients(Ingredient.merge(inputs));
            }
        }
    }

    public void draw(BaseTableCraftingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        this.background.draw(gui);
    }
}

