/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.data;

import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import ru.auriny.infinitech.core.data.base.CoreStateGen;
import ru.auriny.infinitech.registries.BlockRegistry;

public class BlockStateGen
extends CoreStateGen {
    public BlockStateGen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "infinitech", exFileHelper);
    }

    public ModelFile extremeCraftingTable(String name) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/extreme_workbench"))).texture("top", this.modLoc("block/extreme_crafting_table_top"))).texture("side", this.modLoc("block/extreme_crafting_table_side"))).texture("bottom", this.modLoc("block/crystal_block"));
    }

    private void extremeCraftingTable(RegistryObject<Block> blockRegistryObject) {
        this.extremeCraftingTable((Block)blockRegistryObject.get());
    }

    private void extremeCraftingTable(Block block) {
        ModelFile normalModel = this.extremeCraftingTable(this.name(block));
        this.blockItem(block);
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(normalModel).build());
    }

    public ModelFile solarPanel(String name, ResourceLocation top, ResourceLocation bottom, ResourceLocation side) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/solar_panel"))).texture("top", top)).texture("side", side)).texture("bottom", this.models().existingFileHelper.exists(bottom, PackType.CLIENT_RESOURCES, ".png", "textures") ? bottom : side);
    }

    private void solarPanel(RegistryObject<Block> blockRegistryObject) {
        this.solarPanel((Block)blockRegistryObject.get());
    }

    private void solarPanel(Block block) {
        ModelFile normalModel = this.solarPanel(this.name(block), this.modLoc("block/" + this.name(block) + "_top"), this.modLoc("block/" + this.name(block) + "_bottom"), this.modLoc("block/" + this.name(block) + "_side"));
        this.blockItem(block);
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(normalModel).build());
    }

    public ModelFile injector(String name, ResourceLocation energyInput, ResourceLocation mainSide, ResourceLocation injectorSide) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/injector_template"))).texture("injector_main_side", mainSide)).texture("injector_energy_input", energyInput)).texture("injector_side", injectorSide);
    }

    public ModelFile harvester(String name, ResourceLocation top, ResourceLocation mainSide, ResourceLocation side) {
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("block/harvester"))).texture("top", top)).texture("main_side", mainSide)).texture("side", side);
    }

    private void harvester(RegistryObject<Block> blockRegistryObject) {
        this.harvester((Block)blockRegistryObject.get());
    }

    private void injector(RegistryObject<Block> blockRegistryObject) {
        this.injector((Block)blockRegistryObject.get());
    }

    private void injector(Block block) {
        ModelFile normalModel = this.injector(this.name(block), this.modLoc("block/" + this.name(block) + "_energy_input"), this.modLoc("block/" + this.name(block) + "_main_side"), this.modLoc("block/" + this.name(block)));
        this.blockItem(block);
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).modelFile(normalModel).build());
    }

    private void harvester(Block block) {
        ModelFile normalModel = this.harvester(this.name(block), this.modLoc("block/" + this.name(block) + "_top"), this.modLoc("block/" + this.name(block)), this.modLoc("block/" + this.name(block) + "_side"));
        this.blockItem(block);
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile(normalModel).build());
    }

    protected void registerStatesAndModels() {
        this.extremeCraftingTable(BlockRegistry.extremeCraftingTable);
        this.blockWithItem(BlockRegistry.infinityBlock);
        this.blockWithItem(BlockRegistry.blazeCubeBlock);
        this.blockWithItem(BlockRegistry.crystalBlock);
        this.blockWithItem(BlockRegistry.neutroniumBlock);
        this.injector(BlockRegistry.injector);
        this.harvester(BlockRegistry.neutroniumHarvester_1);
        this.harvester(BlockRegistry.neutroniumHarvester_2);
        this.harvester(BlockRegistry.neutroniumHarvester_3);
        this.harvester(BlockRegistry.neutroniumHarvester_4);
        this.harvester(BlockRegistry.neutroniumHarvester_5);
        this.solarPanel(BlockRegistry.solar_panel_1);
        this.solarPanel(BlockRegistry.solar_panel_2);
        this.solarPanel(BlockRegistry.solar_panel_3);
        this.solarPanel(BlockRegistry.solar_panel_4);
        this.solarPanel(BlockRegistry.solar_panel_5);
        this.solarPanel(BlockRegistry.hive_solar_panel);
        this.solarPanel(BlockRegistry.bloody_solar_panel);
        this.solarPanel(BlockRegistry.solar_panel_cosmic_1);
        this.solarPanel(BlockRegistry.solar_panel_cosmic_2);
        this.solarPanel(BlockRegistry.solar_panel_cosmic_3);
        this.solarPanel(BlockRegistry.solar_panel_cosmic_4);
        this.solarPanel(BlockRegistry.solar_panel_magic);
        this.solarPanel(BlockRegistry.solar_panel_manasteel);
        this.solarPanel(BlockRegistry.solar_panel_terrasteel);
        this.solarPanel(BlockRegistry.solar_panel_alfsteel);
        this.solarPanel(BlockRegistry.solar_panel_wyvern);
        this.solarPanel(BlockRegistry.solar_panel_draconic);
        this.solarPanel(BlockRegistry.resonating_solar_panel);
        this.solarPanel(BlockRegistry.solar_panel_chaos);
        this.solarPanel(BlockRegistry.solar_panel_neutronium);
        this.solarPanel(BlockRegistry.solar_panel_infinity);
    }
}

