/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.data;

import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import ru.auriny.infinitech.core.data.base.CoreItemGen;
import ru.auriny.infinitech.registries.ItemRegistry;
import ru.auriny.infinitech.registries.item.CompressedItem;
import ru.auriny.infinitech.registries.item.DefaultItem;

public class ItemModelGen
extends CoreItemGen {
    public ItemModelGen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "infinitech", exFileHelper);
    }

    public ItemModelBuilder handheld(Item item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/handheld"))).texture("layer0", this.modLoc("item/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())));
    }

    public ItemModelBuilder ultimateStew(Item item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/ultimate_stew"))).texture("layer1", this.modLoc("item/stew_overlay"));
    }

    public ItemModelBuilder singularity(Item item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/singularity"))).texture("layer1", this.modLoc("item/singularity_overlay"));
    }

    public ItemModelBuilder compressedItem(CompressedItem item) {
        ResourceLocation lc = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.getOriginal()));
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(lc.m_135827_(), "item/" + lc.m_135815_()));
    }

    public ItemModelBuilder overlayItem(Item item) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", this.modLoc("item/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_())))).texture("layer1", this.modLoc("item/" + Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_()) + "_overlay"));
    }

    protected void registerModels() {
        for (RegistryObject key : ItemRegistry.ITEMS.getEntries()) {
            Item item;
            Object object = key.get();
            if (object instanceof DefaultItem) {
                item = (DefaultItem)((Object)object);
                this.basicItem(item);
            }
            if (!((object = key.get()) instanceof CompressedItem)) continue;
            item = (CompressedItem)((Object)object);
            this.compressedItem((CompressedItem)item);
        }
        this.ultimateStew((Item)ItemRegistry.ultimate_stew.get());
        this.overlayItem((Item)ItemRegistry.neutronium_singularity.get());
        this.singularity((Item)ItemRegistry.lead_singularity.get());
        this.singularity((Item)ItemRegistry.quartz_singularity.get());
        this.singularity((Item)ItemRegistry.silver_singularity.get());
        this.singularity((Item)ItemRegistry.golden_singularity.get());
        this.singularity((Item)ItemRegistry.iron_singularity.get());
        this.singularity((Item)ItemRegistry.lapis_singularity.get());
        this.singularity((Item)ItemRegistry.electro_singularity.get());
        this.singularity((Item)ItemRegistry.redstone_singularity.get());
        this.singularity((Item)ItemRegistry.copper_singularity.get());
        this.singularity((Item)ItemRegistry.nickel_singularity.get());
        this.singularity((Item)ItemRegistry.diamond_singularity.get());
        this.singularity((Item)ItemRegistry.tin_singularity.get());
        this.singularity((Item)ItemRegistry.emerald_singularity.get());
        this.singularity((Item)ItemRegistry.invar_singularity.get());
        this.singularity((Item)ItemRegistry.bronze_singularity.get());
        this.singularity((Item)ItemRegistry.uran_singularity.get());
        this.basicItem((Item)ItemRegistry.infinity_catalyst.get());
        this.handheld((Item)ItemRegistry.blaze_sword.get());
    }
}

