/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.recipes;

import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.core.menu.NeutroniumHarvesterMenu;
import ru.auriny.infinitech.registries.block.tile.NeutroniumHarvesterTile;

public class NeutroniumHarvesterRecipe
implements Recipe<Container> {
    private final int energy;
    private final ItemStack output;
    private final ResourceLocation id;
    private final int time;
    private final int level;

    public NeutroniumHarvesterRecipe(int energy, ItemStack output, ResourceLocation id, int time, int level) {
        this.energy = energy;
        this.output = output;
        this.level = level;
        this.id = id;
        this.time = time;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (pContainer instanceof NeutroniumHarvesterMenu) {
            NeutroniumHarvesterMenu harvester = (NeutroniumHarvesterMenu)pContainer;
            NeutroniumHarvesterTile entity = (NeutroniumHarvesterTile)harvester.blockEntity;
            return entity.harvesterLevel == this.level;
        }
        return false;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getTime() {
        return this.time;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<NeutroniumHarvesterRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("infinitech", "harvester");

        public NeutroniumHarvesterRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            int energy = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"energy");
            int level = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"level");
            int time = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"time");
            return new NeutroniumHarvesterRecipe(energy, output, pRecipeId, time, level);
        }

        @Nullable
        public NeutroniumHarvesterRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int energy = pBuffer.readInt();
            int level = pBuffer.readInt();
            int time = pBuffer.readInt();
            ItemStack output = pBuffer.m_130267_();
            return new NeutroniumHarvesterRecipe(energy, output, pRecipeId, time, level);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, NeutroniumHarvesterRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.getEnergy());
            pBuffer.writeInt(pRecipe.getLevel());
            pBuffer.writeInt(pRecipe.getTime());
            pBuffer.writeItemStack(pRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), false);
        }
    }

    public static class Type
    implements RecipeType<NeutroniumHarvesterRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "harvester";
    }
}

