/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.recipes.auto;

import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import ru.auriny.infinitech.core.recipes.auto.RecipeField;
import ru.auriny.infinitech.core.recipes.auto.RecipeFieldMeta;
import ru.auriny.infinitech.core.recipes.auto.TypeAdapter;

public abstract class AutomatedSerializer<T extends Recipe<?>>
implements RecipeSerializer<T> {
    private final List<RecipeFieldMeta> fields;

    protected AutomatedSerializer(Class<T> recipeClass) {
        this.fields = AutomatedSerializer.scan(recipeClass);
    }

    private static List<RecipeFieldMeta> scan(Class<?> cls) {
        ArrayList<RecipeFieldMeta> result = new ArrayList<RecipeFieldMeta>();
        for (Field field : cls.getDeclaredFields()) {
            TypeAdapter<?> adapter;
            RecipeField rf = field.getAnnotation(RecipeField.class);
            if (rf == null) continue;
            field.setAccessible(true);
            try {
                adapter = rf.adapter().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Cannot create adapter for " + field.getName(), e);
            }
            String jsonName = rf.name().isEmpty() ? field.getName() : rf.name();
            result.add(new RecipeFieldMeta(field, jsonName, adapter));
        }
        return List.copyOf(result);
    }

    public final T m_6729_(ResourceLocation id, JsonObject json) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (RecipeFieldMeta meta : this.fields) {
            values.put(meta.fieldName(), meta.readJson(json, id));
        }
        return this.createInstance(values, id);
    }

    @Nullable
    public T m_8005_(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (RecipeFieldMeta meta : this.fields) {
            Object value = meta.adapter.fromNetwork(buffer);
            values.put(meta.fieldName(), value);
        }
        return this.createInstance(values, recipeId);
    }

    public void m_6178_(FriendlyByteBuf buffer, T recipe) {
        for (RecipeFieldMeta meta : this.fields) {
            meta.writeNetwork(buffer, recipe);
        }
    }

    public <O> O readData(Map<String, Object> map, String key) {
        return (O)map.get(key);
    }

    protected abstract T createInstance(Map<String, Object> var1, ResourceLocation var2);
}

