/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.recipes.auto;

import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ru.auriny.infinitech.core.recipes.auto.AutomatedSerializer;
import ru.auriny.infinitech.core.recipes.auto.RecipeField;
import ru.auriny.infinitech.core.recipes.auto.adapters.FloatAdapter;
import ru.auriny.infinitech.core.recipes.auto.adapters.IngredientListAdapter;
import ru.auriny.infinitech.core.recipes.auto.adapters.IntegerAdapter;
import ru.auriny.infinitech.core.recipes.auto.adapters.ItemStackAdapter;
import ru.auriny.infinitech.registries.RecipesRegistry;

public class InjectorRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    @RecipeField(adapter=IntegerAdapter.class)
    public final int energy;
    @RecipeField(adapter=ItemStackAdapter.class)
    public final ItemStack catalyst;
    @RecipeField(adapter=ItemStackAdapter.class)
    public final ItemStack output;
    @RecipeField(adapter=IngredientListAdapter.class, name="ingredients")
    public final NonNullList<Ingredient> injectorIngredients;
    @RecipeField(adapter=IntegerAdapter.class)
    public final int time;
    @RecipeField(adapter=IntegerAdapter.class)
    public final int level;
    @RecipeField(adapter=FloatAdapter.class)
    public final float unstability;

    public InjectorRecipe(ResourceLocation id, int energy, ItemStack catalyst, ItemStack output, int time, int level, float unstability, NonNullList<Ingredient> ingredients) {
        this.energy = energy;
        this.catalyst = catalyst;
        this.output = output;
        this.level = level;
        this.id = id;
        this.time = time;
        this.injectorIngredients = ingredients;
        this.unstability = unstability;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return this.catalyst.m_41720_() == pContainer.m_8020_(0).m_41720_();
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack getCatalyst() {
        return this.catalyst.m_41777_();
    }

    public NonNullList<Ingredient> getInjectorIngredients() {
        return this.injectorIngredients;
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnergy() {
        return this.energy;
    }

    public float getUnstability() {
        return this.unstability;
    }

    public int getTime() {
        return this.time;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipesRegistry.INJECTOR_RECIPE.get();
    }

    public static class Serializer
    extends AutomatedSerializer<InjectorRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
            super(InjectorRecipe.class);
        }

        @Override
        protected InjectorRecipe createInstance(Map<String, Object> data, ResourceLocation id) {
            return new InjectorRecipe(id, (Integer)this.readData(data, "energy"), (ItemStack)this.readData(data, "catalyst"), (ItemStack)this.readData(data, "output"), (Integer)this.readData(data, "time"), (Integer)this.readData(data, "level"), ((Float)this.readData(data, "unstability")).floatValue(), (NonNullList<Ingredient>)((NonNullList)this.readData(data, "injectorIngredients")));
        }
    }
}

