/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.core.recipes.auto;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import ru.auriny.infinitech.core.recipes.auto.TypeAdapter;

final class RecipeFieldMeta {
    public final Field field;
    public final String jsonName;
    public final TypeAdapter<Object> adapter;

    RecipeFieldMeta(Field field, String jsonName, TypeAdapter<?> adapter) {
        this.field = field;
        this.jsonName = jsonName;
        this.adapter = adapter;
    }

    String fieldName() {
        return this.field.getName();
    }

    Object readJson(JsonObject json, ResourceLocation id) {
        if (!json.has(this.jsonName)) {
            throw new JsonSyntaxException("Missing field " + this.jsonName + " in recipe " + id);
        }
        return this.adapter.fromJson(json, this.jsonName);
    }

    void writeNetwork(FriendlyByteBuf buf, Object recipe) {
        try {
            this.adapter.toNetwork(buf, this.field.get(recipe));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

