/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import ru.auriny.infinitech.registries.RarityRegistry;
import ru.auriny.infinitech.registries.block.CraftingTableBlock;
import ru.auriny.infinitech.registries.block.InjectorBlock;
import ru.auriny.infinitech.registries.block.InjectorCoreBlock;
import ru.auriny.infinitech.registries.block.NeutroniumHarvester;
import ru.auriny.infinitech.registries.block.SolarPanelBlock;

public class BlockRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"infinitech");
    public static final DeferredRegister<Item> BLOCK_ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"infinitech");
    public static final RegistryObject<Block> extremeCraftingTable = BlockRegistry.registerBlock("extreme_crafting_table", () -> new CraftingTableBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50091_)));
    public static final RegistryObject<Block> infinityBlock = BlockRegistry.registerBlock("infinity_block", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_)), RarityRegistry.INFINITY);
    public static final RegistryObject<Block> blazeCubeBlock = BlockRegistry.registerBlock("blaze_cube_block", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_));
    public static final RegistryObject<Block> crystalBlock = BlockRegistry.registerBlock("crystal_block", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_));
    public static final RegistryObject<Block> neutroniumBlock = BlockRegistry.registerBlock("neutronium_block", BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50721_));
    public static final RegistryObject<Block> neutroniumHarvester_1 = BlockRegistry.registerBlock("neutronium_harvester_1", () -> new NeutroniumHarvester.Builder(1, 100, 500).build());
    public static final RegistryObject<Block> neutroniumHarvester_2 = BlockRegistry.registerBlock("neutronium_harvester_2", () -> new NeutroniumHarvester.Builder(2, 250, 1000).build());
    public static final RegistryObject<Block> neutroniumHarvester_3 = BlockRegistry.registerBlock("neutronium_harvester_3", () -> new NeutroniumHarvester.Builder(3, 500, 1500).build());
    public static final RegistryObject<Block> neutroniumHarvester_4 = BlockRegistry.registerBlock("neutronium_harvester_4", () -> new NeutroniumHarvester.Builder(4, 1000, 2500).build());
    public static final RegistryObject<Block> neutroniumHarvester_5 = BlockRegistry.registerBlock("neutronium_harvester_5", () -> new NeutroniumHarvester.Builder(5, 2000, 5000).build());
    public static final RegistryObject<Block> injector = BlockRegistry.registerBlock("injector", () -> new InjectorBlock.Builder(1, 2000, 5000, BlockBehaviour.Properties.m_284310_().m_60955_()).build());
    public static final RegistryObject<Block> injector_core = BlockRegistry.registerBlock("injector_core", () -> new InjectorCoreBlock(BlockBehaviour.Properties.m_284310_()));
    public static final RegistryObject<Block> solar_panel_1 = BlockRegistry.registerBlock("solar_panel_1", () -> new SolarPanelBlock.Builder(4, 16, 1000).build());
    public static final RegistryObject<Block> solar_panel_2 = BlockRegistry.registerBlock("solar_panel_2", () -> new SolarPanelBlock.Builder(32, 128, 8000).setNight(15).build());
    public static final RegistryObject<Block> solar_panel_3 = BlockRegistry.registerBlock("solar_panel_3", () -> new SolarPanelBlock.Builder(128, 512, 28000).setNight(20).build(), Rarity.UNCOMMON);
    public static final RegistryObject<Block> solar_panel_4 = BlockRegistry.registerBlock("solar_panel_4", () -> new SolarPanelBlock.Builder(512, 2048, 100000).setNight(25).build(), Rarity.RARE);
    public static final RegistryObject<Block> solar_panel_5 = BlockRegistry.registerBlock("solar_panel_5", () -> new SolarPanelBlock.Builder(1024, 4028, 250000).setNight(30).build(), Rarity.EPIC);
    public static final RegistryObject<Block> hive_solar_panel = BlockRegistry.registerBlock("hive_solar_panel", () -> new SolarPanelBlock.Builder(1528, 5028, 328000).build(), Rarity.EPIC);
    public static final RegistryObject<Block> bloody_solar_panel = BlockRegistry.registerBlock("bloody_solar_panel", () -> new SolarPanelBlock.Builder(2024, 6028, 512000).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_cosmic_1 = BlockRegistry.registerBlock("solar_panel_cosmic_1", () -> new SolarPanelBlock.Builder(218, 1024, 65000).setNight(25).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_cosmic_2 = BlockRegistry.registerBlock("solar_panel_cosmic_2", () -> new SolarPanelBlock.Builder(524, 4024, 125000).setNight(50).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_cosmic_3 = BlockRegistry.registerBlock("solar_panel_cosmic_3", () -> new SolarPanelBlock.Builder(1024, 8024, 245000).setNight(75).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_cosmic_4 = BlockRegistry.registerBlock("solar_panel_cosmic_4", () -> new SolarPanelBlock.Builder(4028, 10240, 365000).setNight(100).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_magic = BlockRegistry.registerBlock("solar_panel_magic", () -> new SolarPanelBlock.Builder(316, 1024, 100000).setNight(32).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_manasteel = BlockRegistry.registerBlock("solar_panel_manasteel", () -> new SolarPanelBlock.Builder(1024, 3120, 200000).setNight(33).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_terrasteel = BlockRegistry.registerBlock("solar_panel_terrasteel", () -> new SolarPanelBlock.Builder(2048, 5120, 400000).setNight(35).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_alfsteel = BlockRegistry.registerBlock("solar_panel_alfsteel", () -> new SolarPanelBlock.Builder(4048, 16056, 1200000).setNight(38).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_wyvern = BlockRegistry.registerBlock("solar_panel_wyvern", () -> new SolarPanelBlock.Builder(24000, 81920, 64000000).setNight(40).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_draconic = BlockRegistry.registerBlock("solar_panel_draconic", () -> new SolarPanelBlock.Builder(98000, 263000, 128000000).setNight(50).build(), Rarity.EPIC);
    public static final RegistryObject<Block> resonating_solar_panel = BlockRegistry.registerBlock("resonating_solar_panel", () -> new SolarPanelBlock.Builder(128000, 312000, 256000000).setNight(60).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_chaos = BlockRegistry.registerBlock("solar_panel_chaos", () -> new SolarPanelBlock.Builder(196000, 527000, 512000000).setNight(60).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_neutronium = BlockRegistry.registerBlock("solar_panel_neutronium", () -> new SolarPanelBlock.Builder(250000, 750000, 1000000000).setNight(65).build(), Rarity.EPIC);
    public static final RegistryObject<Block> solar_panel_infinity = BlockRegistry.registerBlock("solar_panel_infinity", () -> new SolarPanelBlock.Builder(512000, 1500000, 2100000000).setNight(75).build(), RarityRegistry.INFINITY);

    private static RegistryObject<Block> registerBlock(String name, BlockBehaviour.Properties props) {
        return BlockRegistry.registerBlock(name, () -> new Block(props));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        return BlockRegistry.registerBlock(name, block, Rarity.COMMON);
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String registryName, Supplier<T> block, Rarity rarity) {
        RegistryObject registeredBlock = BLOCKS.register(registryName, block);
        BLOCK_ITEMS.register(registryName, () -> new BlockItem((Block)registeredBlock.get(), new Item.Properties().m_41497_(rarity)));
        return registeredBlock;
    }
}

