/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import ru.auriny.infinitech.core.recipes.BaseTableCraftingRecipe;
import ru.auriny.infinitech.core.recipes.NeutroniumHarvesterRecipe;
import ru.auriny.infinitech.core.recipes.ShapedTableCraftingRecipe;
import ru.auriny.infinitech.core.recipes.ShapelessTableCraftingRecipe;
import ru.auriny.infinitech.core.recipes.auto.InjectorRecipe;

public class RecipesRegistry {
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"infinitech");
    public static final RegistryObject<RecipeSerializer<NeutroniumHarvesterRecipe>> HARVESTER_SERIALIZER = SERIALIZERS.register("harvester", () -> NeutroniumHarvesterRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<ShapedTableCraftingRecipe>> SHAPED_SERIALIZER = SERIALIZERS.register("shaped_extreme", () -> ShapedTableCraftingRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<ShapelessTableCraftingRecipe>> SHAPELESS_SERIALIZER = SERIALIZERS.register("shapeless_extreme", () -> ShapelessTableCraftingRecipe.Serializer.INSTANCE);
    public static final RegistryObject<RecipeSerializer<InjectorRecipe>> INJECTOR_SERIALIZER = SERIALIZERS.register("injector", () -> InjectorRecipe.Serializer.INSTANCE);
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"infinitech");
    public static final RegistryObject<RecipeType<BaseTableCraftingRecipe>> CRAFTING_TABLE_RECIPE = RecipesRegistry.recipe("crafting_table_recipe", () -> RecipeType.simple((ResourceLocation)new ResourceLocation("infinitech", "crafting_table_recipe")));
    public static final RegistryObject<RecipeType<InjectorRecipe>> INJECTOR_RECIPE = RecipesRegistry.recipe("injector", () -> RecipeType.simple((ResourceLocation)new ResourceLocation("infinitech", "injector")));

    public static <T extends Recipe<Container>> RegistryObject<RecipeType<T>> recipe(String name, Supplier<RecipeType<T>> type) {
        return RECIPES.register(name, type);
    }

    public static void register(IEventBus eventBus) {
        RECIPES.register(eventBus);
        SERIALIZERS.register(eventBus);
    }
}

