/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import ru.auriny.infinitech.core.menu.NeutroniumHarvesterMenu;
import ru.auriny.infinitech.core.util.NumberFormatter;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.block.tile.NeutroniumHarvesterTile;

public class NeutroniumHarvester
extends BaseEntityBlock {
    private final Builder builder;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public NeutroniumHarvester(Builder builder) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(4.0f, 8.0f).m_60918_(SoundType.f_56743_));
        this.builder = builder;
    }

    @Deprecated
    @NotNull
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        return ((BlockEntityType)TileEntityRegistry.NEUTRONIUM_HARVESTER.get()).m_155264_(pPos, pState);
    }

    public void m_6240_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable BlockEntity pBlockEntity, @NotNull ItemStack pTool) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
        if (!pLevel.f_46443_ && pLevel instanceof ServerLevel) {
            NeutroniumHarvester.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return TickableBlockEntity.getTickerHelper();
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof NeutroniumHarvesterTile) {
                NeutroniumHarvesterTile solar = (NeutroniumHarvesterTile)tile;
                SimpleContainer inv = new SimpleContainer(solar.itemOutputHandler.getSlots() + 1);
                inv.m_6836_(0, solar.itemOutputHandler.getStackInSlot(0));
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inv);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        MenuProvider containerProvider = this.createContainerProvider(world, pos);
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)tileEntity.m_58899_());
        return InteractionResult.CONSUME;
    }

    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237119_();
            }

            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new NeutroniumHarvesterMenu(i, worldIn, pos, playerInventory, playerEntity);
            }
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public void m_5871_(@NotNull ItemStack pStack, @Nullable BlockGetter pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237113_((String)String.format("\u041f\u043e\u0434\u0430\u0447\u0430: %s FE/\u0442\u0438\u043a", NumberFormatter.formatNumber(this.getRfTick()))).m_130940_(ChatFormatting.YELLOW));
        pTooltip.add((Component)Component.m_237113_((String)String.format("\u0412\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c: %s FE", NumberFormatter.formatNumber(this.getRfCapacity()))).m_130940_(ChatFormatting.GREEN));
    }

    public int getLevel() {
        return this.builder.level;
    }

    public int getRfTick() {
        return this.builder.consumption;
    }

    public int getRfCapacity() {
        return this.builder.rfCapacity;
    }

    public int getRfTransfer() {
        return this.builder.transfer;
    }

    public static class Builder {
        private int consumption;
        private int transfer;
        private int rfCapacity;
        private int level;

        public Builder(int level, int consumption, int rfCapacity) {
            this.level = level;
            this.consumption = consumption;
            this.rfCapacity = rfCapacity;
            this.transfer = consumption / 2;
        }

        public Builder(int level, int consumption, int transfer, int rfCapacity) {
            this.level = level;
            this.consumption = consumption;
            this.rfCapacity = rfCapacity;
            this.transfer = transfer;
        }

        public NeutroniumHarvester build() {
            return new NeutroniumHarvester(this);
        }
    }
}

