/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import ru.auriny.infinitech.core.menu.SolarPanelMenu;
import ru.auriny.infinitech.core.util.NumberFormatter;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.block.tile.SolarPanelTile;
import ru.justagod.cutter.GradleSide;
import ru.justagod.cutter.GradleSideOnly;

public class SolarPanelBlock
extends BaseEntityBlock {
    private final Builder builder;

    public SolarPanelBlock(Builder builder) {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60999_().m_60913_(4.0f, 8.0f).m_60918_(SoundType.f_56743_));
        this.builder = builder;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)TileEntityRegistry.SOLAR_PANEL.get()).m_155264_(pPos, pState);
    }

    public void m_6240_(Level pLevel, Player pPlayer, BlockPos pPos, BlockState pState, BlockEntity pBlockEntity, ItemStack pTool) {
        super.m_6240_(pLevel, pPlayer, pPos, pState, pBlockEntity, pTool);
        if (!pLevel.f_46443_ && pLevel instanceof ServerLevel) {
            SolarPanelBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)this));
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TickableBlockEntity.getTickerHelper();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof SolarPanelTile) {
                SolarPanelTile solar = (SolarPanelTile)tile;
                SimpleContainer inv = new SimpleContainer(solar.itemHandler.getSlots() + 1);
                for (int i = 0; i < solar.itemHandler.getSlots(); ++i) {
                    inv.m_6836_(i, solar.itemHandler.getStackInSlot(i));
                }
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inv);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int id, int param) {
        super.m_8133_(state, world, pos, id, param);
        BlockEntity tile = world.m_7702_(pos);
        return tile != null && tile.m_7531_(id, param);
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileEntity = world.m_7702_(pos);
        MenuProvider containerProvider = this.createContainerProvider(world, pos);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)containerProvider, (BlockPos)(tileEntity != null ? tileEntity.m_58899_() : null));
        }
        return InteractionResult.CONSUME;
    }

    @GradleSideOnly(value={GradleSide.SERVER})
    private MenuProvider createContainerProvider(final Level worldIn, final BlockPos pos) {
        return new MenuProvider(){

            public Component m_5446_() {
                return Component.m_237119_();
            }

            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new SolarPanelMenu(i, worldIn, pos, playerInventory, playerEntity);
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    @GradleSideOnly(value={GradleSide.CLIENT})
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    @GradleSideOnly(value={GradleSide.CLIENT})
    public void m_5871_(ItemStack pStack, BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        super.m_5871_(pStack, pLevel, pTooltip, pFlag);
        pTooltip.add((Component)Component.m_237113_((String)String.format("\u0412\u044b\u0440\u0430\u0431\u043e\u0442\u043a\u0430: %s FE/\u0442\u0438\u043a", NumberFormatter.formatNumber(this.getRfTick()))).m_130940_(ChatFormatting.YELLOW));
        pTooltip.add((Component)Component.m_237113_((String)String.format(" - \u0414\u043d\u0451\u043c: %s%%", NumberFormatter.formatNumber(this.getDay()))).m_130940_(ChatFormatting.GRAY));
        pTooltip.add((Component)Component.m_237113_((String)String.format(" - \u041d\u043e\u0447\u044c\u044e: %s%%", NumberFormatter.formatNumber(this.getNight()))).m_130940_(ChatFormatting.DARK_GRAY));
        pTooltip.add((Component)Component.m_237113_((String)String.format("\u041f\u0435\u0440\u0435\u0434\u0430\u0447\u0430: %s FE/\u0442\u0438\u043a", NumberFormatter.formatNumber(this.getRfTransfer()))).m_130940_(ChatFormatting.GOLD));
        pTooltip.add((Component)Component.m_237113_((String)String.format("\u0412\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0441\u0442\u044c: %s FE", NumberFormatter.formatNumber(this.getRfCapacity()))).m_130940_(ChatFormatting.GREEN));
    }

    public int getRfTick() {
        return this.builder.rfTick;
    }

    public int getRfCapacity() {
        return this.builder.rfCapacity;
    }

    public int getRfTransfer() {
        return this.builder.rfTransfer;
    }

    public int getDay() {
        return this.builder.day;
    }

    public int getNight() {
        return this.builder.night;
    }

    public static class Builder {
        private int rfTick;
        private int rfCapacity;
        private int day;
        private int night;
        private int rfTransfer;

        public Builder(int rfTick, int rfTransfer, int rfCapacity) {
            this.rfTick = rfTick;
            this.rfTransfer = rfTransfer;
            this.rfCapacity = rfCapacity;
            this.day = 100;
            this.night = 0;
        }

        public Builder setNight(int n) {
            this.night = n;
            return this;
        }

        public Builder setDay(int d) {
            this.day = d;
            return this;
        }

        public SolarPanelBlock build() {
            return new SolarPanelBlock(this);
        }
    }
}

