/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import ru.auriny.infinitech.core.util.Utils;

public abstract class AbstractConsumerTile
extends BlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    public int rfExtraction;
    public int rfReceive;
    public int rfCapacity;
    public int rfStored;
    public int progress;
    public int maxProgress;
    public EnergyStorage ENERGY_STORAGE;
    public LazyOptional<IEnergyStorage> lazyEnergyHandler;

    public AbstractConsumerTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == Direction.UP) {
                return LazyOptional.empty();
            }
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public void m_7651_() {
        super.m_7651_();
        this.lazyEnergyHandler.invalidate();
    }

    public boolean canExtract() {
        return this.ENERGY_STORAGE.canExtract();
    }

    public boolean canReceive() {
        return this.ENERGY_STORAGE.canReceive();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        this.m_6596_();
        return this.ENERGY_STORAGE.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.m_6596_();
        return this.ENERGY_STORAGE.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.rfStored;
    }

    public int getMaxEnergyStored() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    public int getConsumption() {
        return this.rfExtraction;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getTransfer() {
        return this.rfReceive;
    }

    public void m_183515_(CompoundTag pTag) {
        this.rfStored = this.ENERGY_STORAGE.getEnergyStored();
        pTag.m_128405_("EnergyStored", this.rfStored);
        pTag.m_128405_("Consumption", this.getConsumption());
        pTag.m_128405_("Transfer", this.getTransfer());
        pTag.m_128405_("Progress", this.getProgress());
        pTag.m_128405_("MaxProgress", this.getMaxProgress());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.rfStored = pTag.m_128441_("EnergyStored") ? pTag.m_128451_("EnergyStored") : 0;
        this.ENERGY_STORAGE = new EnergyStorage(this.rfCapacity, this.rfReceive, this.rfExtraction, this.rfStored);
        if (pTag.m_128441_("Consumption")) {
            this.rfExtraction = pTag.m_128451_("Consumption");
        }
        if (pTag.m_128441_("Transfer")) {
            this.rfReceive = pTag.m_128451_("Transfer");
        }
        if (pTag.m_128441_("Progress")) {
            this.progress = pTag.m_128451_("Progress");
        }
        if (pTag.m_128441_("MaxProgress")) {
            this.maxProgress = pTag.m_128451_("MaxProgress");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Utils.SUpdateTileEntityPacket(this);
        }
    }

    public void extractEnergy(ItemStack stack) {
        LazyOptional energyCap = stack.getCapability(ForgeCapabilities.ENERGY);
        if (energyCap.isPresent()) {
            energyCap.ifPresent(handler -> {
                if (handler.canReceive()) {
                    int extracted = this.extractEnergy(this.rfExtraction, true);
                    int received = handler.receiveEnergy(extracted, false);
                    this.extractEnergy(received, false);
                }
            });
        }
    }

    public void extractEnergy(BlockEntity neighbor, Direction direction) {
        LazyOptional energyCap = neighbor.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
        if (energyCap.isPresent()) {
            energyCap.ifPresent(handler -> {
                if (handler.canReceive()) {
                    int extracted = this.extractEnergy(this.rfExtraction, true);
                    int received = handler.receiveEnergy(extracted, false);
                    this.extractEnergy(received, false);
                }
            });
        }
    }
}

