/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;

public abstract class AbstractGeneratorTile
extends BlockEntity
implements TickableBlockEntity,
IEnergyStorage {
    public int rfTick;
    public int rfCapacity;
    public int rfStored;
    public int rfTransfer;
    public int day;
    public int night;
    public EnergyStorage ENERGY_STORAGE;
    public LazyOptional<IEnergyStorage> lazyEnergyHandler;

    public AbstractGeneratorTile(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            if (side == Direction.UP) {
                return LazyOptional.empty();
            }
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyEnergyHandler.invalidate();
    }

    public void m_7651_() {
        super.m_7651_();
        this.lazyEnergyHandler.invalidate();
    }

    public boolean canExtract() {
        return this.ENERGY_STORAGE.canExtract();
    }

    public boolean canReceive() {
        return this.ENERGY_STORAGE.canReceive();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        this.m_6596_();
        return this.ENERGY_STORAGE.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.m_6596_();
        return this.ENERGY_STORAGE.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.rfStored;
    }

    public int getMaxEnergyStored() {
        return this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    public int getProduction() {
        return this.rfTick;
    }

    public void m_183515_(CompoundTag pTag) {
        this.rfStored = this.ENERGY_STORAGE.getEnergyStored();
        pTag.m_128405_("EnergyStored", this.rfStored);
        pTag.m_128405_("Production", this.getProduction());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.rfStored = pTag.m_128441_("EnergyStored") ? pTag.m_128451_("EnergyStored") : 0;
        this.ENERGY_STORAGE = new EnergyStorage(this.rfCapacity, this.rfTick, this.rfTransfer, this.rfStored);
        if (pTag.m_128441_("Production")) {
            this.rfTick = pTag.m_128451_("Production");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            AbstractGeneratorTile.updateTileEntityPacket(this);
        }
    }

    public static void updateTileEntityPacket(BlockEntity tile) {
        Packet packet;
        if (tile.m_58904_() instanceof ServerLevel && (packet = tile.m_58483_()) != null) {
            BlockPos pos = tile.m_58899_();
            ((ServerChunkCache)tile.m_58904_().m_7726_()).f_8325_.m_183262_(new ChunkPos(pos), false).forEach(e -> e.f_8906_.m_9829_(packet));
        }
    }

    public void extractEnergy(ItemStack stack) {
        LazyOptional energyCap = stack.getCapability(ForgeCapabilities.ENERGY);
        if (energyCap.isPresent()) {
            energyCap.ifPresent(handler -> {
                if (handler.canReceive()) {
                    int extracted = this.extractEnergy(this.rfTransfer, true);
                    int received = handler.receiveEnergy(extracted, false);
                    this.extractEnergy(received, false);
                }
            });
        }
    }

    public void extractEnergy(BlockEntity neighbor, Direction direction) {
        LazyOptional energyCap = neighbor.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
        if (energyCap.isPresent()) {
            energyCap.ifPresent(handler -> {
                if (handler.canReceive()) {
                    int extracted = this.extractEnergy(this.rfTransfer, true);
                    int received = handler.receiveEnergy(extracted, false);
                    this.extractEnergy(received, false);
                }
            });
        }
    }
}

