/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block.tile;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.common.registry.block.entity.TickableBlockEntity;
import pro.komaru.tridot.util.Tmp;
import ru.auriny.infinitech.core.recipes.auto.InjectorRecipe;
import ru.auriny.infinitech.core.util.Utils;
import ru.auriny.infinitech.registries.RecipesRegistry;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.block.tile.InjectorTile;

public class InjectorCoreTile
extends BlockEntity
implements TickableBlockEntity {
    private final SimpleContainer itemHandler = this.createItemHandler();
    public int progress;
    public int maxProgress;
    private boolean isCrafting;
    public static final List<BlockPos> OFFSETS = BlockPos.m_121886_((int)-3, (int)0, (int)-3, (int)3, (int)1, (int)3).filter(p_207914_ -> Math.abs(p_207914_.m_123341_()) == 3 || Math.abs(p_207914_.m_123343_()) == 3).map(BlockPos::m_7949_).toList();
    private InjectorRecipe activeRecipe;
    private List<InjectorTile> connectedInjectors = new ArrayList<InjectorTile>();
    private final List<Ingredient> remainingIngredients = new ArrayList<Ingredient>();
    private List<BlockPos> clientInjectorPositions = new ArrayList<BlockPos>();

    public InjectorCoreTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistry.CORE_INJECTOR.get(), pos, state);
        this.itemHandler.m_19164_(i -> this.m_6596_());
    }

    public boolean isCrafting() {
        return this.isCrafting;
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.activeRecipe == null) {
            this.checkForRecipe();
        }
        if (this.activeRecipe != null) {
            this.processCraftingCycle();
        } else if (this.itemHandler.m_8020_(0).m_41619_()) {
            this.resetProgress();
            this.isCrafting = false;
            this.m_6596_();
        }
    }

    private void checkForRecipe() {
        ItemStack catalyst = this.itemHandler.m_8020_(0);
        if (catalyst.m_41619_()) {
            return;
        }
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)RecipesRegistry.INJECTOR_RECIPE.get());
        List<InjectorTile> foundInjectors = this.getValidInjectors();
        ArrayList<ItemStack> availableItems = new ArrayList<ItemStack>();
        for (InjectorTile tile : foundInjectors) {
            if (tile.getItemHandler().m_8020_(0).m_41619_()) continue;
            availableItems.add(tile.getItemHandler().m_8020_(0));
        }
        for (InjectorRecipe recipe : recipes) {
            if (!this.isValidRecipe(recipe, catalyst, foundInjectors, availableItems)) continue;
            this.startCrafting(recipe, foundInjectors);
            return;
        }
    }

    public List<BlockPos> getConnectedInjectorsPos() {
        if (this.f_58857_.f_46443_) {
            return this.clientInjectorPositions;
        }
        return this.connectedInjectors.stream().map(BlockEntity::m_58899_).collect(Collectors.toList());
    }

    private void startCrafting(InjectorRecipe recipe, List<InjectorTile> injectors) {
        this.activeRecipe = recipe;
        this.connectedInjectors = injectors;
        this.maxProgress = recipe.getTime();
        this.progress = 0;
        this.remainingIngredients.clear();
        this.remainingIngredients.addAll((Collection<Ingredient>)recipe.getInjectorIngredients());
        this.m_6596_();
    }

    private void processCraftingCycle() {
        ItemStack item = this.itemHandler.m_8020_(0);
        if (item.m_41619_() || !this.activeRecipe.getCatalyst().m_150930_(item.m_41720_())) {
            this.resetProgress();
            return;
        }
        if (!this.checkIntegrityAndPause() || !this.hasEnergy()) {
            this.isCrafting = false;
            this.m_6596_();
            return;
        }
        ++this.progress;
        this.isCrafting = true;
        if ((float)this.progress < (float)this.maxProgress * 0.85f) {
            this.handleRandomEvents();
        }
        if (this.progress >= this.maxProgress) {
            this.finishCrafting();
            this.consumeIngredients();
        }
        this.m_6596_();
    }

    private boolean checkIntegrityAndPause() {
        ArrayList<Ingredient> checklist = new ArrayList<Ingredient>(this.remainingIngredients);
        block0: for (InjectorTile tile : this.connectedInjectors) {
            ItemStack stack = tile.getItemHandler().m_8020_(0);
            if (stack.m_41619_()) continue;
            Iterator it = checklist.iterator();
            while (it.hasNext()) {
                if (!((Ingredient)it.next()).test(stack)) continue;
                it.remove();
                continue block0;
            }
        }
        return checklist.isEmpty();
    }

    private void handleRandomEvents() {
        if (Tmp.rnd.chance(0.005f)) {
            this.triggerInstability();
        }
    }

    private void consumeIngredients() {
        if (this.remainingIngredients.isEmpty()) {
            return;
        }
        for (InjectorTile tile : this.connectedInjectors) {
            ItemStack stack = tile.getItemHandler().m_8020_(0);
            if (!stack.m_41619_()) {
                tile.getItemHandler().m_7407_(0, 1);
                this.remainingIngredients.clear();
                return;
            }
            tile.clearGhost();
        }
    }

    private void triggerInstability() {
        ArrayList<InjectorTile> candidates = new ArrayList<InjectorTile>();
        for (InjectorTile tile : this.connectedInjectors) {
            if (tile.getItemHandler().m_8020_(0).m_41619_()) continue;
            candidates.add(tile);
        }
        if (candidates.isEmpty()) {
            return;
        }
        InjectorTile victim = (InjectorTile)((Object)candidates.get(this.f_58857_.f_46441_.m_188503_(candidates.size())));
        ItemStack lostStack = victim.getItemHandler().m_8020_(0);
        victim.triggerGhost(lostStack);
        victim.getItemHandler().m_7407_(0, 1);
        this.f_58857_.m_46796_(2001, victim.m_58899_(), Block.m_49956_((BlockState)victim.m_58900_()));
    }

    private boolean isValidRecipe(InjectorRecipe recipe, ItemStack catalyst, List<InjectorTile> foundInjectors, List<ItemStack> availableItems) {
        if (!recipe.getCatalyst().m_150930_(catalyst.m_41720_())) {
            return false;
        }
        if (catalyst.m_41613_() < recipe.getCatalyst().m_41613_()) {
            return false;
        }
        ArrayList<Ingredient> required = new ArrayList<Ingredient>((Collection<Ingredient>)recipe.getInjectorIngredients());
        ArrayList<ItemStack> availableCopy = new ArrayList<ItemStack>(availableItems);
        for (InjectorTile tile : foundInjectors) {
            if (tile.injectorLevel >= recipe.getLevel()) continue;
            return false;
        }
        if (availableCopy.size() != required.size()) {
            return false;
        }
        for (Ingredient ingredient : required) {
            boolean found = false;
            Iterator it = availableCopy.iterator();
            while (it.hasNext()) {
                ItemStack stack = (ItemStack)it.next();
                if (!ingredient.test(stack)) continue;
                it.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean hasEnergy() {
        boolean hasEnergy = true;
        ArrayList<Ingredient> required = new ArrayList<Ingredient>((Collection<Ingredient>)this.activeRecipe.getInjectorIngredients());
        block0: for (InjectorTile injector : this.connectedInjectors) {
            for (Ingredient ingredient : required) {
                if (!ingredient.test(injector.getItemHandler().m_8020_(0)) || injector.getEnergyStored() >= this.activeRecipe.getEnergy()) continue;
                hasEnergy = false;
                continue block0;
            }
        }
        return hasEnergy;
    }

    private void finishCrafting() {
        if (this.activeRecipe == null) {
            return;
        }
        ArrayList<Ingredient> required = new ArrayList<Ingredient>((Collection<Ingredient>)this.activeRecipe.getInjectorIngredients());
        ArrayList<InjectorTile> tempInjectors = new ArrayList<InjectorTile>(this.connectedInjectors);
        block0: for (Ingredient ingredient : required) {
            Iterator it = tempInjectors.iterator();
            while (it.hasNext()) {
                InjectorTile tile = (InjectorTile)((Object)it.next());
                ItemStack stack = tile.getItemHandler().m_8020_(0);
                tile.clearGhost();
                if (!ingredient.test(stack)) continue;
                tile.getItemHandler().m_7407_(0, 1);
                tile.extractEnergy(this.activeRecipe.getEnergy(), false);
                tile.m_6596_();
                it.remove();
                continue block0;
            }
        }
        this.itemHandler.m_7407_(0, 1);
        this.itemHandler.m_19173_(this.activeRecipe.m_8043_(this.f_58857_.m_9598_()));
        this.resetProgress();
        this.activeRecipe = null;
        this.connectedInjectors.clear();
        this.m_6596_();
    }

    private List<InjectorTile> getValidInjectors() {
        ArrayList<InjectorTile> tiles = new ArrayList<InjectorTile>();
        for (BlockPos offset : OFFSETS) {
            BlockPos targetPos = this.f_58858_.m_121955_((Vec3i)offset);
            BlockEntity blockEntity = this.f_58857_.m_7702_(targetPos);
            if (!(blockEntity instanceof InjectorTile)) continue;
            InjectorTile injector = (InjectorTile)blockEntity;
            tiles.add(injector);
        }
        return tiles;
    }

    private void resetProgress() {
        this.activeRecipe = null;
        this.maxProgress = 0;
        this.progress = 0;
    }

    private static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.m_6643_() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.m_6836_(i, (ItemStack)src.get(i));
        }
    }

    public static void addHandPlayerItem(Level level, Player player, InteractionHand hand, ItemStack stack, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) >= 0) {
            InjectorCoreTile.addPlayerItem(level, player, addStack);
        } else if (stack.m_41619_()) {
            player.m_21008_(hand, addStack.m_41777_());
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)addStack) && stack.m_41613_() + addStack.m_41613_() <= addStack.m_41741_()) {
            stack.m_41764_(stack.m_41613_() + addStack.m_41613_());
            player.m_21008_(hand, stack);
        } else {
            InjectorCoreTile.addPlayerItem(level, player, addStack);
        }
    }

    public static void addPlayerItem(Level level, Player player, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) != -1 || player.m_150109_().m_36062_() > -1) {
            player.m_150109_().m_36054_(addStack.m_41777_());
        } else {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), addStack.m_41777_()));
        }
    }

    private static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ret.set(i, (Object)inv.m_8020_(i));
        }
        return ret;
    }

    public final int inventorySize() {
        return this.getItemHandler().m_6643_();
    }

    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
    }

    public final Container getItemHandler() {
        return this.itemHandler;
    }

    public void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("Progress", this.progress);
        pTag.m_128405_("MaxProgress", this.maxProgress);
        pTag.m_128379_("IsCrafting", this.isCrafting);
        ArrayList<Long> posLongs = new ArrayList<Long>();
        List<InjectorTile> sourceList = this.connectedInjectors;
        for (InjectorTile tile : sourceList) {
            posLongs.add(tile.m_58899_().m_121878_());
        }
        pTag.m_128428_("ConnectedInjectors", posLongs);
        ContainerHelper.m_18973_((CompoundTag)pTag, InjectorCoreTile.copyFromInv((Container)this.itemHandler));
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("Progress")) {
            this.progress = pTag.m_128451_("Progress");
        }
        if (pTag.m_128441_("MaxProgress")) {
            this.maxProgress = pTag.m_128451_("MaxProgress");
        }
        if (pTag.m_128441_("IsCrafting")) {
            this.isCrafting = pTag.m_128471_("IsCrafting");
        }
        if (pTag.m_128441_("ConnectedInjectors")) {
            long[] posLongs = pTag.m_128467_("ConnectedInjectors");
            this.clientInjectorPositions.clear();
            for (long p : posLongs) {
                this.clientInjectorPositions.add(BlockPos.m_122022_((long)p));
            }
        }
        NonNullList tmp = NonNullList.m_122780_((int)this.inventorySize(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, (NonNullList)tmp);
        InjectorCoreTile.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public final CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void m_6596_() {
        super.m_6596_();
        this.syncClient();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            Utils.SUpdateTileEntityPacket(this);
        }
    }

    public void syncClient() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

