/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block.tile;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.block.InjectorBlock;
import ru.auriny.infinitech.registries.block.tile.AbstractConsumerTile;
import ru.auriny.infinitech.registries.block.tile.InjectorCoreTile;

public class InjectorTile
extends AbstractConsumerTile {
    private final SimpleContainer itemHandler = this.createItemHandler();
    public int injectorLevel;
    BlockPos coreOffset;
    Direction coreDirection;
    public ItemStack ghostItem = ItemStack.f_41583_;

    public InjectorTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistry.INJECTOR.get(), pos, state);
        this.itemHandler.m_19164_(i -> this.m_6596_());
        this.injectorLevel = ((InjectorBlock)state.m_60734_()).getLevel();
        this.rfExtraction = Integer.MAX_VALUE;
        this.rfCapacity = ((InjectorBlock)state.m_60734_()).getRfCapacity();
        this.rfReceive = ((InjectorBlock)state.m_60734_()).getRfTick();
        this.ENERGY_STORAGE = new EnergyStorage(this.rfCapacity, this.rfReceive, this.rfExtraction);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public InjectorCoreTile getCore() {
        BlockPos corePos = this.getCorePos();
        if (corePos != null) {
            BlockEntity tile = this.f_58857_.m_7702_(corePos);
            if (tile instanceof InjectorCoreTile) {
                return (InjectorCoreTile)tile;
            }
            this.coreOffset = null;
        }
        return null;
    }

    @Nullable
    private BlockPos getCorePos() {
        return this.coreOffset == null ? null : this.f_58858_.m_121996_((Vec3i)this.coreOffset);
    }

    public void setCore(@Nullable InjectorCoreTile core) {
        BlockPos offset;
        if (core == null) {
            this.coreOffset = null;
            return;
        }
        this.coreOffset = offset = this.f_58858_.m_121996_((Vec3i)core.m_58899_());
        this.coreDirection = Direction.m_122372_((float)offset.m_123341_(), (float)offset.m_123342_(), (float)offset.m_123343_()).m_122424_();
    }

    private static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.m_6643_() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.m_6836_(i, (ItemStack)src.get(i));
        }
    }

    public static void addHandPlayerItem(Level level, Player player, InteractionHand hand, ItemStack stack, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) >= 0) {
            InjectorTile.addPlayerItem(level, player, addStack);
        } else if (stack.m_41619_()) {
            player.m_21008_(hand, addStack.m_41777_());
        } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)addStack) && stack.m_41613_() + addStack.m_41613_() <= addStack.m_41741_()) {
            stack.m_41764_(stack.m_41613_() + addStack.m_41613_());
            player.m_21008_(hand, stack);
        } else {
            InjectorTile.addPlayerItem(level, player, addStack);
        }
    }

    public static void addPlayerItem(Level level, Player player, ItemStack addStack) {
        if (player.m_150109_().m_36050_(addStack) != -1 || player.m_150109_().m_36062_() > -1) {
            player.m_150109_().m_36054_(addStack.m_41777_());
        } else {
            level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), addStack.m_41777_()));
        }
    }

    private static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ret.set(i, (Object)inv.m_8020_(i));
        }
        return ret;
    }

    public void clearGhost() {
        if (this.ghostItem.m_41619_()) {
            return;
        }
        this.ghostItem = ItemStack.f_41583_;
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public void triggerGhost(ItemStack stack) {
        this.ghostItem = stack.m_41777_();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NonNullList tmp = NonNullList.m_122780_((int)this.inventorySize(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)tmp);
        InjectorTile.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
        if (tag.m_128441_("level")) {
            this.injectorLevel = tag.m_128451_("level");
        }
        if (tag.m_128441_("GhostItem")) {
            this.ghostItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("GhostItem"));
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, InjectorTile.copyFromInv((Container)this.itemHandler));
        tag.m_128405_("level", this.injectorLevel);
        if (!this.ghostItem.m_41619_()) {
            tag.m_128365_("GhostItem", (Tag)this.ghostItem.m_41739_(new CompoundTag()));
        }
    }

    public final int inventorySize() {
        return this.getItemHandler().m_6643_();
    }

    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public int m_6893_() {
                return 1;
            }
        };
    }

    public final Container getItemHandler() {
        return this.itemHandler;
    }

    public void tick() {
    }

    @Override
    public void m_6596_() {
        super.m_6596_();
        this.syncClient();
    }

    public void syncClient() {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }
}

