/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block.tile;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.util.Tmp;
import ru.auriny.infinitech.core.recipes.NeutroniumHarvesterRecipe;
import ru.auriny.infinitech.registries.SoundsRegistry;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.block.NeutroniumHarvester;
import ru.auriny.infinitech.registries.block.tile.AbstractConsumerTile;

public class NeutroniumHarvesterTile
extends AbstractConsumerTile {
    public final ItemStackHandler itemOutputHandler = this.createHandler(1);
    public final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> this.itemOutputHandler);
    public int harvesterLevel;
    public int ambientSoundTime;

    public NeutroniumHarvesterTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistry.NEUTRONIUM_HARVESTER.get(), pos, state);
        this.harvesterLevel = ((NeutroniumHarvester)state.m_60734_()).getLevel();
        this.rfExtraction = ((NeutroniumHarvester)state.m_60734_()).getRfTransfer();
        this.rfCapacity = ((NeutroniumHarvester)state.m_60734_()).getRfCapacity();
        this.rfReceive = ((NeutroniumHarvester)state.m_60734_()).getRfTick();
        this.ENERGY_STORAGE = new EnergyStorage(this.rfCapacity, this.rfReceive, this.rfExtraction);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    public int getAmbientSoundInterval() {
        return 80;
    }

    private void resetAmbientSoundTime() {
        this.ambientSoundTime = -this.getAmbientSoundInterval();
    }

    public void playAmbientSound() {
        SoundEvent soundevent = this.getAmbientSound();
        if (soundevent != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), this.getAmbientSound(), SoundSource.BLOCKS, 1.0f, Tmp.rnd.nextFloat(1.0f));
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)SoundsRegistry.BIOLOOP.get();
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            ++this.ambientSoundTime;
            Optional<NeutroniumHarvesterRecipe> recipe = this.getCurrentRecipe();
            ItemStack output = this.itemOutputHandler.getStackInSlot(0);
            if (recipe.isPresent() && output.m_41753_() && output.m_41613_() < output.m_41741_() && this.itemOutputHandler.isItemValid(0, output)) {
                if (this.rfStored <= 0) {
                    return;
                }
                this.increaseCraftingProgress(recipe.get());
                this.setMaxProgress();
                NeutroniumHarvesterTile.m_155232_((Level)this.f_58857_, (BlockPos)this.m_58899_(), (BlockState)this.m_58900_());
                this.extractEnergy(recipe.get().getEnergy(), false);
                if (this.ambientSoundTime >= 0) {
                    this.resetAmbientSoundTime();
                    this.playAmbientSound();
                }
                if (this.hasProgressFinished(recipe.get())) {
                    this.craftItem(recipe.get());
                    this.resetProgress();
                }
                this.m_6596_();
            } else {
                this.resetProgress();
            }
        }
    }

    private void craftItem(NeutroniumHarvesterRecipe recipe) {
        ItemStack result = recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_);
        this.itemOutputHandler.insertItem(0, result, false);
    }

    public Optional<NeutroniumHarvesterRecipe> getCurrentRecipe() {
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)NeutroniumHarvesterRecipe.Type.INSTANCE);
        for (NeutroniumHarvesterRecipe recipe : recipes) {
            if (this.harvesterLevel != recipe.getLevel()) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    private boolean hasProgressFinished(NeutroniumHarvesterRecipe recipe) {
        return this.progress >= recipe.getTime();
    }

    private void increaseCraftingProgress(NeutroniumHarvesterRecipe recipe) {
        if (this.progress < recipe.getTime()) {
            ++this.progress;
        }
    }

    private void setMaxProgress() {
        Optional<NeutroniumHarvesterRecipe> recipe = this.getCurrentRecipe();
        if (this.maxProgress <= 0) {
            this.maxProgress = recipe.map(NeutroniumHarvesterRecipe::getTime).orElse(200);
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                NeutroniumHarvesterTile.this.m_6596_();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                CombinedInvWrapper item = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemOutputHandler});
                return LazyOptional.of(() -> item).cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("level")) {
            this.harvesterLevel = pTag.m_128451_("level");
        }
        this.itemOutputHandler.deserializeNBT(pTag.m_128469_("output"));
    }

    @Override
    public void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128405_("level", this.harvesterLevel);
        pTag.m_128365_("output", (Tag)this.itemOutputHandler.serializeNBT());
    }
}

