/*
 * Decompiled with CFR 0.152.
 */
package ru.auriny.infinitech.registries.block.tile;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import ru.auriny.infinitech.registries.TileEntityRegistry;
import ru.auriny.infinitech.registries.block.SolarPanelBlock;
import ru.auriny.infinitech.registries.block.tile.AbstractGeneratorTile;

public class SolarPanelTile
extends AbstractGeneratorTile {
    public final ItemStackHandler itemHandler = this.createHandler(9);
    public final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);

    public SolarPanelTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileEntityRegistry.SOLAR_PANEL.get(), pos, state);
        this.rfTick = ((SolarPanelBlock)state.m_60734_()).getRfTick();
        this.rfCapacity = ((SolarPanelBlock)state.m_60734_()).getRfCapacity();
        this.rfTransfer = ((SolarPanelBlock)state.m_60734_()).getRfTransfer();
        this.day = ((SolarPanelBlock)state.m_60734_()).getDay();
        this.night = ((SolarPanelBlock)state.m_60734_()).getNight();
        this.ENERGY_STORAGE = new EnergyStorage(this.rfCapacity, this.rfTick, this.rfTransfer);
        this.lazyEnergyHandler = LazyOptional.of(() -> this.ENERGY_STORAGE);
    }

    private ItemStackHandler createHandler(int size) {
        return new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                SolarPanelTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                CombinedInvWrapper item = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});
                return LazyOptional.of(() -> item).cast();
            }
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("inv")) {
            this.itemHandler.deserializeNBT(pTag.m_128469_("inv"));
        }
    }

    @Override
    public int getProduction() {
        return this.f_58857_ != null && this.f_58857_.m_46461_() ? (int)((double)this.rfTick * ((double)this.day / 100.0)) : (int)((double)this.rfTick * ((double)this.night / 100.0));
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (this.f_58857_.m_45527_(this.m_58899_().m_7494_())) {
            this.receiveEnergy(this.getProduction(), false);
        }
        for (int j = 0; j < this.itemHandler.getSlots(); ++j) {
            ItemStack stack = this.itemHandler.getStackInSlot(j);
            if (stack.m_41619_()) continue;
            this.extractEnergy(stack);
        }
        for (Direction direction : Direction.values()) {
            BlockEntity neighbor;
            if (direction == Direction.UP || (neighbor = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction))) == null || neighbor instanceof SolarPanelTile) continue;
            this.extractEnergy(neighbor, direction);
        }
    }
}

