/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class TickingData
extends SavedData {
    private final Object2IntMap<UUID> tickMap = new Object2IntOpenHashMap();

    public TickingData() {
        this.tickMap.defaultReturnValue(-1);
    }

    public static TickingData load(CompoundTag pCompound) {
        TickingData data = new TickingData();
        data.tickMap.clear();
        data.tickMap.defaultReturnValue(-1);
        ListTag decayList = pCompound.m_128437_("result", 10);
        for (int i = 0; i < decayList.size(); ++i) {
            CompoundTag thisTag = decayList.m_128728_(i);
            data.tickMap.put((Object)thisTag.m_128342_("id"), thisTag.m_128451_("value"));
        }
        return data;
    }

    public boolean isComplete(UUID id) {
        return this.tickMap.getInt((Object)id) == 0 || this.tickMap.getInt((Object)id) == 1;
    }

    public int getValue(UUID id) {
        return this.tickMap.getInt((Object)id);
    }

    public boolean setValue(UUID id, int decayAmount) {
        return this.tickMap.put((Object)id, decayAmount) == -1;
    }

    public int remove(UUID id) {
        return this.tickMap.removeInt((Object)id);
    }

    public boolean tick() {
        if (this.tickMap.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            int value = entry.getIntValue();
            if (value <= 0) continue;
            entry.setValue(value - 1);
            changed = true;
        }
        return changed;
    }

    public CompoundTag m_7176_(CompoundTag pCompound) {
        ListTag decayList = new ListTag();
        for (Object2IntMap.Entry entry : this.tickMap.object2IntEntrySet()) {
            CompoundTag thisTag = new CompoundTag();
            thisTag.m_128362_("id", (UUID)entry.getKey());
            thisTag.m_128405_("value", entry.getIntValue());
            decayList.add((Object)thisTag);
        }
        pCompound.m_128365_("result", (Tag)decayList);
        return pCompound;
    }

    public void m_77757_(File pFile) {
        if (this.m_77764_()) {
            pFile.getParentFile().mkdirs();
        }
        super.m_77757_(pFile);
    }
}

