/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon;

import com.klikli_dev.modonomicon.Modonomicon;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.bookstate.BookVisualStateManager;
import com.klikli_dev.modonomicon.client.BookModelLoader;
import com.klikli_dev.modonomicon.client.ClientTicks;
import com.klikli_dev.modonomicon.client.render.MultiblockPreviewRenderer;
import com.klikli_dev.modonomicon.client.render.page.PageRendererRegistry;
import com.klikli_dev.modonomicon.config.ClientConfig;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import com.klikli_dev.modonomicon.data.MultiblockDataManager;
import com.klikli_dev.modonomicon.datagen.DataGenerators;
import com.klikli_dev.modonomicon.item.BookOpenStateItemPropertyGetter;
import com.klikli_dev.modonomicon.network.Networking;
import com.klikli_dev.modonomicon.registry.CommandRegistry;
import com.klikli_dev.modonomicon.registry.CreativeModeTabRegistry;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="modonomicon")
public class ModonomiconForge {
    public ModonomiconForge() {
        Modonomicon.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.get().spec);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        CreativeModeTabRegistry.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onCommonSetup);
        modEventBus.addListener(CreativeModeTabRegistry::onCreativeModeTabBuildContents);
        MinecraftForge.EVENT_BUS.addListener(e -> {
            e.addListener((PreparableReloadListener)BookDataManager.get());
            e.addListener((PreparableReloadListener)MultiblockDataManager.get());
        });
        MinecraftForge.EVENT_BUS.addListener(e -> CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        MinecraftForge.EVENT_BUS.addListener(e -> CommandRegistry.registerClientCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() != null) {
                BookDataManager.get().onDatapackSync(e.getPlayer());
                MultiblockDataManager.get().onDatapackSync(e.getPlayer());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            Entity patt4669$temp = e.getEntity();
            if (patt4669$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt4669$temp;
                BookUnlockStateManager.get().updateAndSyncFor(player);
                BookVisualStateManager.get().syncFor(player);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            Level level;
            LevelAccessor patt5192$temp = e.getLevel();
            if (patt5192$temp instanceof Level && (level = (Level)patt5192$temp).m_46472_() == Level.f_46428_) {
                BookUnlockStateManager.get().saveData = null;
                BookVisualStateManager.get().saveData = null;
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> BookUnlockStateManager.get().onAdvancement((ServerPlayer)e.getEntity()));
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase == TickEvent.Phase.END) {
                BookUnlockStateManager.get().onServerTickEnd(e.getServer());
            }
        });
        modEventBus.addListener(DataGenerators::gatherData);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            modEventBus.addListener(Client::onClientSetup);
            modEventBus.addListener(Client::onRegisterGeometryLoaders);
            modEventBus.addListener(Client::onRegisterGuiOverlays);
            MinecraftForge.EVENT_BUS.addListener(Client::onRecipesUpdated);
            modEventBus.addListener(e -> e.registerReloadListener((PreparableReloadListener)BookDataManager.Client.get()));
        }
    }

    public void onCommonSetup(FMLCommonSetupEvent event) {
        Networking.registerMessages();
        LoaderRegistry.registerLoaders();
    }

    public static class Client {
        public static void onClientSetup(FMLClientSetupEvent event) {
            PageRendererRegistry.registerPageRenderers();
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.END) {
                    ClientTicks.endClientTick(Minecraft.m_91087_());
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.START) {
                    ClientTicks.renderTickStart(e.renderTickTime);
                } else {
                    ClientTicks.renderTickEnd();
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                InteractionResult result = MultiblockPreviewRenderer.onPlayerInteract(e.getEntity(), e.getLevel(), e.getHand(), e.getHitVec());
                if (result.m_19077_()) {
                    e.setCanceled(true);
                    e.setCancellationResult(result);
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.phase == TickEvent.Phase.END) {
                    MultiblockPreviewRenderer.onClientTick(Minecraft.m_91087_());
                }
            });
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.getStage() == RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
                    MultiblockPreviewRenderer.onRenderLevelLastEvent(e.getPoseStack());
                }
            });
            event.enqueueWork(() -> ItemProperties.registerGeneric((ResourceLocation)Modonomicon.loc("open_state"), (ItemPropertyFunction)new BookOpenStateItemPropertyGetter()));
        }

        public static void onRecipesUpdated(RecipesUpdatedEvent event) {
            BookDataManager.get().onRecipesUpdated((Level)Minecraft.m_91087_().f_91073_);
        }

        public static void onRegisterGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            event.register("book_model_loader", (IGeometryLoader)new BookModelLoader());
        }

        public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerBelow(VanillaGuiOverlay.BOSS_EVENT_PROGRESS.id(), "multiblock_hud", (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> MultiblockPreviewRenderer.onRenderHUD(guiGraphics, partialTick));
        }
    }
}

