/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.modsoptimizer.config;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.markusbordihn.modsoptimizer.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ModsDatabaseUpdater {
    private static final String LOG_PREFIX = "[Mods Database Updater]";
    private static final Path CONFIG_DIR = Paths.get("", new String[0]).toAbsolutePath().resolve("config").resolve("mods_optimizer");
    private static final Path LOCAL_FILE = CONFIG_DIR.resolve("mods-database.json");
    private static final String REMOTE_URL = "https://raw.githubusercontent.com/MarkusBordihn/BOs-Mods-Optimizer/1.18.2/Common/src/main/resources/mods-database.json";
    private static final int CACHE_MAX_AGE_HOURS = 24;
    private static final Set<String> VALID_KEYS = Set.of("client", "server", "both");

    public static void updateFromRemoteIfNeeded() {
        try {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            if (Files.exists(LOCAL_FILE, new LinkOption[0])) {
                Instant lastModified = Files.getLastModifiedTime(LOCAL_FILE, new LinkOption[0]).toInstant();
                if (ModsDatabaseUpdater.isManuallyModified(LOCAL_FILE)) {
                    Constants.LOG.info("{} \ud83d\uded1 Local mods-database.json was modified by user, skipping remote update.", (Object)LOG_PREFIX);
                    return;
                }
                if (lastModified.plus(Duration.ofHours(24L)).isAfter(Instant.now())) {
                    Constants.LOG.info("{} \u23f3 Local mods-database.json is still fresh (last update: {}).", (Object)LOG_PREFIX, (Object)lastModified);
                    return;
                }
                Constants.LOG.info("{} \ud83d\udd04 Local mods-database.json is outdated, fetching from remote \u2026", (Object)LOG_PREFIX);
            }
            try (InputStream inputStream = new URL(REMOTE_URL).openStream();){
                Files.copy(inputStream, LOCAL_FILE, StandardCopyOption.REPLACE_EXISTING);
                String newHash = ModsDatabaseUpdater.calculateSha256(LOCAL_FILE);
                Files.writeString(LOCAL_FILE.resolveSibling("mods-database.json.sha256"), (CharSequence)newHash, StandardCharsets.UTF_8, new OpenOption[0]);
                Constants.LOG.info("{} \u2705 Fetched remote mods-database.json and saved SHA-256 hash.", (Object)LOG_PREFIX);
            }
        }
        catch (IOException e) {
            Constants.LOG.warn("{} \u26a0 Failed to update mods-database.json: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonObject getModsDatabase() {
        InputStream inputStream;
        if (Files.exists(LOCAL_FILE, new LinkOption[0])) {
            try {
                inputStream = Files.newInputStream(LOCAL_FILE, new OpenOption[0]);
                try {
                    JsonObject jsonObject22 = ModsDatabaseUpdater.parseAndValidate(inputStream);
                    if (jsonObject22 != null) {
                        JsonObject jsonObject3 = jsonObject22;
                        return jsonObject3;
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException e) {
                Constants.LOG.warn("{} \u26a0 Failed to read local mods-database.json: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            }
        }
        try {
            inputStream = ModsDatabaseUpdater.class.getClassLoader().getResourceAsStream("mods-database.json");
            try {
                JsonObject jsonObject2;
                if (inputStream != null && (jsonObject2 = ModsDatabaseUpdater.parseAndValidate(inputStream)) != null) {
                    JsonObject jsonObject = jsonObject2;
                    return jsonObject;
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            Constants.LOG.warn("{} \u26a0 Failed to read fallback mods-database.json: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
        }
        Constants.LOG.error("{} \u274c Could not load any valid mods-database.json!", (Object)LOG_PREFIX);
        return new JsonObject();
    }

    public static Map<String, String> getSortedModDatabaseMap(JsonObject jsonObject) {
        TreeMap<String, String> modIdMap = new TreeMap<String, String>();
        ModsDatabaseUpdater.addEntriesToMap(jsonObject, "client", "client", modIdMap);
        ModsDatabaseUpdater.addEntriesToMap(jsonObject, "server", "server", modIdMap);
        ModsDatabaseUpdater.addEntriesToMap(jsonObject, "both", "default", modIdMap);
        return modIdMap;
    }

    private static void addEntriesToMap(JsonObject jsonObject, String key, String value, Map<String, String> map) {
        if (jsonObject.has(key)) {
            jsonObject.getAsJsonArray(key).forEach(jsonElement -> map.put(jsonElement.getAsString(), value));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject parseAndValidate(InputStream inputStream) {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            for (String key : VALID_KEYS) {
                if (jsonObject.has(key) && jsonObject.get(key).isJsonArray()) continue;
                Constants.LOG.warn("{} \u26a0 Key '{}' missing or invalid in mods-database.json", (Object)LOG_PREFIX, (Object)key);
                JsonObject jsonObject2 = null;
                return jsonObject2;
            }
            JsonObject jsonObject3 = jsonObject;
            return jsonObject3;
        }
        catch (Exception e) {
            Constants.LOG.warn("{} \u26a0 Failed to parse mods-database.json: {}", (Object)LOG_PREFIX, (Object)e.getMessage());
            return null;
        }
    }

    private static boolean isManuallyModified(Path path) {
        Path hashFile = path.resolveSibling(path.getFileName() + ".sha256");
        if (!Files.exists(path, new LinkOption[0]) || !Files.exists(hashFile, new LinkOption[0])) {
            return false;
        }
        try {
            boolean modified;
            String expectedHash = Files.readString(hashFile, StandardCharsets.UTF_8).trim();
            String actualHash = ModsDatabaseUpdater.calculateSha256(path);
            boolean bl = modified = !expectedHash.equals(actualHash);
            if (modified) {
                Constants.LOG.info("{} \ud83d\uded1 mods-database.json was modified (SHA-256 hash mismatch)", (Object)LOG_PREFIX);
            }
            return modified;
        }
        catch (IOException e) {
            Constants.LOG.warn("{} \u26a0 Failed to check hash for {}: {}", new Object[]{LOG_PREFIX, path.getFileName(), e.getMessage()});
            return false;
        }
    }

    private static String calculateSha256(Path file) throws IOException {
        String string;
        block10: {
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                int bytesRead;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] buffer = new byte[8192];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    digest.update(buffer, 0, bytesRead);
                }
                byte[] hashBytes = digest.digest();
                StringBuilder stringBuilder = new StringBuilder();
                for (byte b : hashBytes) {
                    stringBuilder.append(String.format("%02x", b));
                }
                string = stringBuilder.toString();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("[Mods Database Updater] Unable to calculate SHA-256 hash for " + file, e);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

