/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.modsoptimizer.data;

import de.markusbordihn.modsoptimizer.Constants;
import de.markusbordihn.modsoptimizer.thirdparty.toml4j.Toml;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class TomlFileParser {
    private TomlFileParser() {
    }

    public static Toml readTomlFile(JarFile jarFile, Path path) {
        return TomlFileParser.readTomlFile(jarFile, path, false);
    }

    public static Toml tryReadTomlFile(JarFile jarFile, Path path) {
        return TomlFileParser.readTomlFile(jarFile, path, true);
    }

    public static Toml readTomlFile(JarFile jarFile, Path path, boolean ignoreErrors) {
        block12: {
            String normalizedPath = TomlFileParser.normalizePath(path);
            ZipEntry modsFile = jarFile.getEntry(normalizedPath);
            if (modsFile != null && !modsFile.isDirectory()) {
                Toml toml;
                block11: {
                    InputStream inputStream = jarFile.getInputStream(modsFile);
                    try {
                        toml = new Toml().read(inputStream);
                        if (inputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            if (!ignoreErrors) {
                                Constants.LOG.error("Error reading TOML file {} from {}: {}", new Object[]{path, jarFile, e});
                            }
                            break block12;
                        }
                    }
                    inputStream.close();
                }
                return toml;
            }
            if (!ignoreErrors) {
                Constants.LOG.error("TOML file {} not found in {}", (Object)normalizedPath, (Object)jarFile);
            }
        }
        return new Toml();
    }

    private static String normalizePath(Path path) {
        return path.toString().replace("\\", "/");
    }
}

