/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.lightoverlay.render;

import at.ridgo8.moreoverlays.api.lightoverlay.ILightRenderer;
import at.ridgo8.moreoverlays.api.lightoverlay.ILightScanner;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class NumberOverlayRenderer
implements ILightRenderer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderOverlays(ILightScanner scanner, PoseStack matrixstack) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.f_91073_ == null) {
            return;
        }
        Font font = mc.f_91062_;
        MultiBufferSource.BufferSource bufferSource = Objects.requireNonNull(mc.m_91269_().m_110104_());
        Camera camera = mc.f_91063_.m_109153_();
        double cameraX = camera.m_90583_().f_82479_;
        double cameraY = camera.m_90583_().f_82480_;
        double cameraZ = camera.m_90583_().f_82481_;
        RenderSystem.enableDepthTest();
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.enablePolygonOffset();
        RenderSystem.polygonOffset((float)-2.0f, (float)-4.0f);
        RenderSystem.depthMask((boolean)false);
        ClientLevel world = Objects.requireNonNull(mc.f_91073_);
        BlockPos playerPos = player.m_20183_();
        int up = (Integer)Config.light_UpRange.get();
        int down = (Integer)Config.light_DownRange.get();
        int hr = (Integer)Config.light_HRange.get();
        float scale = (float)((Double)Config.render_spawnNumberScale.get()).doubleValue();
        int save = (Integer)Config.light_SaveLevel.get();
        HashSet<BlockPos> spawnablePositions = new HashSet<BlockPos>();
        for (Pair<BlockPos, Byte> pair : scanner.getLightModes()) {
            if (pair.getRight() == null || (Byte)pair.getRight() == 0) continue;
            spawnablePositions.add((BlockPos)pair.getLeft());
        }
        try {
            for (int xo = -hr; xo <= hr; ++xo) {
                for (int zo = -hr; zo <= hr; ++zo) {
                    for (int yo = -down; yo <= up; ++yo) {
                        BlockState airState;
                        BlockPos airPos = new BlockPos(playerPos.m_123341_() + xo, playerPos.m_123342_() + yo, playerPos.m_123343_() + zo);
                        BlockPos belowPos = airPos.m_7495_();
                        BlockState belowState = world.m_8055_(belowPos);
                        if (!belowState.m_60783_((BlockGetter)world, belowPos, Direction.UP) || (airState = world.m_8055_(airPos)).m_60838_((BlockGetter)world, airPos)) continue;
                        int blockLight = world.m_45517_(LightLayer.BLOCK, airPos);
                        int skyLight = world.m_45517_(LightLayer.SKY, airPos);
                        if (blockLight == 0 && !spawnablePositions.contains(airPos)) continue;
                        int color = blockLight >= save ? 0xFF000000 | (Integer)Config.render_spawnSafeColor.get() : (skyLight >= save ? 0xFF000000 | (Integer)Config.render_spawnNColor.get() : 0xFF000000 | (Integer)Config.render_spawnAColor.get());
                        String text = String.valueOf(blockLight);
                        float y = airState.m_204336_(BlockTags.f_144279_) ? (float)airPos.m_123342_() + 0.125f + 0.02f : (float)belowPos.m_123342_() + 1.0f + 0.02f;
                        matrixstack.m_85836_();
                        matrixstack.m_85837_((double)airPos.m_123341_() + 0.5 + 0.045 - cameraX, (double)y - cameraY, (double)airPos.m_123343_() + 0.5 + 0.088 - cameraZ);
                        matrixstack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                        matrixstack.m_85841_(scale, -scale, scale);
                        float xoff = (float)(-font.m_92895_(text)) / 2.0f;
                        Objects.requireNonNull(font);
                        float yoff = (float)(-9) / 2.0f;
                        Matrix4f pose = matrixstack.m_85850_().m_252922_();
                        font.m_271703_(text, xoff, yoff, color, false, pose, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                        matrixstack.m_85849_();
                    }
                }
            }
            bufferSource.m_109911_();
        }
        finally {
            RenderSystem.depthMask((boolean)true);
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableCull();
        }
    }
}

