/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.api.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.notenoughanimations.versionless.animations.BowAnimation;
import dev.tr7zw.transition.mc.EntityUtil;
import java.util.EnumSet;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;

public class CustomBowAnimation
extends BasicAnimation {
    private HumanoidModel.ArmPose rightArmPose;
    private HumanoidModel.ArmPose leftArmPose;
    private final EnumSet<HumanoidModel.ArmPose> twoHandedAnimatios = EnumSet.of(HumanoidModel.ArmPose.BOW_AND_ARROW);
    private final BodyPart[] parts = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM, BodyPart.BODY};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.bowAnimation == BowAnimation.CUSTOM_V1;
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        this.rightArmPose = AnimationUtil.getArmPose(entity, entity.m_5737_() == HumanoidArm.LEFT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        this.leftArmPose = AnimationUtil.getArmPose(entity, entity.m_5737_() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        return this.twoHandedAnimatios.contains(this.leftArmPose) || this.twoHandedAnimatios.contains(this.rightArmPose);
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.parts;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 3200;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel model, BodyPart part, float delta, float tickCounter) {
        int invert;
        boolean bowInLeftHand;
        ModelPart mainArm = model.f_102811_;
        ModelPart offArm = model.f_102812_;
        BodyPart mainPart = BodyPart.RIGHT_ARM;
        BodyPart offPart = BodyPart.LEFT_ARM;
        boolean bl = bowInLeftHand = entity.m_5737_() == HumanoidArm.RIGHT && entity.m_7655_() == InteractionHand.OFF_HAND || entity.m_5737_() == HumanoidArm.LEFT && entity.m_7655_() == InteractionHand.MAIN_HAND;
        if (bowInLeftHand) {
            mainArm = model.f_102812_;
            offArm = model.f_102811_;
            mainPart = BodyPart.LEFT_ARM;
            offPart = BodyPart.RIGHT_ARM;
        }
        int n = invert = bowInLeftHand ? -1 : 1;
        if (part == mainPart) {
            mainArm.f_104204_ = (float)invert * Mth.m_14036_((float)(-0.1f + AnimationUtil.wrapDegrees(-model.f_102808_.f_104203_)), (float)-1.25f, (float)0.5f);
            mainArm.f_104203_ = Mth.m_14036_((float)(-1.5707964f + (float)invert * AnimationUtil.wrapDegrees(model.f_102808_.f_104204_)), (float)-2.0f, (float)0.0f);
            mainArm.f_104205_ += (float)invert * 1.5f;
        }
        if (part == offPart) {
            offArm.f_104204_ = (float)invert * Mth.m_14036_((float)(0.1f + AnimationUtil.wrapDegrees(-model.f_102808_.f_104203_)), (float)-1.05f, (float)0.7f);
            offArm.f_104203_ = Mth.m_14036_((float)(-1.5707964f + (float)invert * AnimationUtil.wrapDegrees(model.f_102808_.f_104204_) + 0.8f), (float)-1.05f, (float)-0.65f);
            offArm.f_104205_ += (float)invert * 1.5f;
        }
        if (part == BodyPart.BODY && NEABaseMod.config.customBowRotationLock) {
            if (bowInLeftHand) {
                entity.f_20883_ = EntityUtil.getYRot((Entity)entity) + 40.0f;
                entity.f_20884_ = entity.f_19859_ + 40.0f;
            } else {
                entity.f_20883_ = EntityUtil.getYRot((Entity)entity) - 40.0f;
                entity.f_20884_ = entity.f_19859_ - 40.0f;
            }
        }
    }
}

