/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DirectionalBlockShape {
    protected final float length;
    protected final float width;
    protected final float height;
    protected final float center;
    protected final VoxelShape up;
    protected final VoxelShape down;
    protected final VoxelShape west;
    protected final VoxelShape east;
    protected final VoxelShape north;
    protected final VoxelShape south;

    public DirectionalBlockShape(float length, float width, float height) {
        this(length, width, height, 8.0f);
    }

    public DirectionalBlockShape(float length, float width, float height, float center) {
        this.length = length;
        this.width = width;
        this.height = height;
        this.center = center;
        this.up = Block.m_49796_((double)(center - width / 2.0f), (double)0.0, (double)(center - length / 2.0f), (double)(center + width / 2.0f), (double)height, (double)(center + length / 2.0f));
        this.down = Block.m_49796_((double)(center - width / 2.0f), (double)(16.0f - height), (double)(center - length / 2.0f), (double)(center + width / 2.0f), (double)16.0, (double)(center + length / 2.0f));
        this.west = Block.m_49796_((double)(16.0f - height), (double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)16.0, (double)(center + width / 2.0f), (double)(center + length / 2.0f));
        this.east = Block.m_49796_((double)0.0, (double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)height, (double)(center + width / 2.0f), (double)(center + length / 2.0f));
        this.north = Block.m_49796_((double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)(16.0f - height), (double)(center + width / 2.0f), (double)(center + length / 2.0f), (double)16.0);
        this.south = Block.m_49796_((double)(center - width / 2.0f), (double)(center - length / 2.0f), (double)0.0, (double)(center + width / 2.0f), (double)(center + length / 2.0f), (double)height);
    }

    public VoxelShape getShape(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> this.up;
            case Direction.DOWN -> this.down;
            case Direction.WEST -> this.west;
            case Direction.EAST -> this.east;
            case Direction.NORTH -> this.north;
            case Direction.SOUTH -> this.south;
        };
    }

    public VoxelShape up() {
        return this.up;
    }

    public VoxelShape down() {
        return this.down;
    }

    public VoxelShape west() {
        return this.west;
    }

    public VoxelShape east() {
        return this.east;
    }

    public VoxelShape north() {
        return this.north;
    }

    public VoxelShape south() {
        return this.south;
    }
}

