/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.util;

import com.klikli_dev.occultism.common.item.armor.OtherworldGogglesItem;
import com.klikli_dev.occultism.common.item.storage.SatchelItem;
import com.klikli_dev.occultism.common.item.storage.StorageRemoteItem;
import java.util.Optional;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtil {
    public static boolean hasGoggles(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (OtherworldGogglesItem.isGogglesItem(helmet)) {
            return true;
        }
        Optional<Boolean> hasGoggles = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> curiosHandler.getCurios().values()).map(slotsHandler -> slotsHandler.stream().map(ICurioStacksHandler::getStacks).map(stackHandler -> {
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                ItemStack stack = stackHandler.getStackInSlot(i);
                if (!OtherworldGogglesItem.isGogglesItem(stack)) continue;
                return true;
            }
            return false;
        })).map(results -> results.anyMatch(found -> found));
        return hasGoggles.orElse(false);
    }

    public static ItemStack getBackpack(Player player) {
        ICuriosItemHandler curiosHandler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
        if (curiosHandler == null) {
            return ItemStack.f_41583_;
        }
        for (String curio : curiosHandler.getCurios().keySet()) {
            ItemStack stack = CuriosUtil.getSatchelItemFromSlot(curiosHandler, curio);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    protected static ItemStack getSatchelItemFromSlot(ICuriosItemHandler curiosHandler, String identifier) {
        ICurioStacksHandler slotHandler = curiosHandler.getStacksHandler(identifier).orElse(null);
        if (slotHandler == null) {
            return ItemStack.f_41583_;
        }
        IDynamicStackHandler stackHandler = slotHandler.getStacks();
        for (int i = 0; i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof SatchelItem)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static SelectedCurio getStorageRemote(Player player) {
        int selectedSlot = player.m_150109_().f_35977_;
        ItemStack storageRemoteStack = player.m_150109_().m_36056_();
        if (!(storageRemoteStack.m_41720_() instanceof StorageRemoteItem)) {
            selectedSlot = -1;
            storageRemoteStack = CuriosUtil.getStorageRemoteCurio(player);
        }
        if (!(storageRemoteStack.m_41720_() instanceof StorageRemoteItem)) {
            selectedSlot = CuriosUtil.getFirstStorageRemoteSlot(player);
            ItemStack itemStack = storageRemoteStack = selectedSlot > 0 ? player.m_150109_().m_8020_(selectedSlot) : ItemStack.f_41583_;
        }
        if (storageRemoteStack.m_41720_() instanceof StorageRemoteItem) {
            return new SelectedCurio(storageRemoteStack, selectedSlot);
        }
        return null;
    }

    public static ItemStack getStorageRemoteCurio(Player player) {
        Optional hasStorageRemote = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(curiosHandler -> {
            for (ICurioStacksHandler curiosStackshandler : curiosHandler.getCurios().values()) {
                IDynamicStackHandler stackHandler = curiosStackshandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof StorageRemoteItem)) continue;
                    return stack;
                }
            }
            return ItemStack.f_41583_;
        });
        return hasStorageRemote.orElse(ItemStack.f_41583_);
    }

    public static int getFirstBackpackSlot(Player player) {
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            ItemStack stack = player.m_150109_().m_8020_(slot);
            if (!(stack.m_41720_() instanceof SatchelItem)) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstStorageRemoteSlot(Player player) {
        for (int slot = 0; slot < player.m_150109_().m_6643_(); ++slot) {
            ItemStack stack = player.m_150109_().m_8020_(slot);
            if (!(stack.m_41720_() instanceof StorageRemoteItem)) continue;
            return slot;
        }
        return -1;
    }

    public static class SelectedCurio {
        public ItemStack itemStack;
        public int selectedSlot;

        public SelectedCurio(ItemStack itemStack, int selectedSlot) {
            this.itemStack = itemStack;
            this.selectedSlot = selectedSlot;
        }
    }
}

