/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.client.gui.buttons;

import com.heaser.pipeconnector.client.gui.buttons.BaseButton;
import com.heaser.pipeconnector.constants.BridgeType;
import com.heaser.pipeconnector.network.NetworkHandler;
import com.heaser.pipeconnector.network.UpdateBridgeTypePacket;
import com.heaser.pipeconnector.utils.TagUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class BridgeTypeButton
extends BaseButton {
    public BridgeTypeButton(ItemStack itemStack) {
        super(BridgeTypeButton.getInitialLabel(itemStack), 20, 123);
    }

    @Override
    public void onClick(Button clickedButton, ItemStack itemStack) {
        BridgeType bridgeType = TagUtils.getBridgeType(itemStack);
        if (bridgeType == BridgeType.DEFAULT) {
            bridgeType = BridgeType.A_STAR;
            this.setLabel("item.pipe_connector.gui.button.aStarPathfinding", null);
            this.button.m_93666_(this.getLabel());
        } else if (bridgeType == BridgeType.A_STAR) {
            bridgeType = BridgeType.DEFAULT;
            this.setLabel("item.pipe_connector.gui.button.defaultPathfinding", null);
            this.button.m_93666_(this.getLabel());
        }
        NetworkHandler.CHANNEL.sendToServer((Object)new UpdateBridgeTypePacket(bridgeType));
    }

    private static Component getInitialLabel(ItemStack itemStack) {
        BridgeType bridgeType = TagUtils.getBridgeType(itemStack);
        return switch (bridgeType) {
            case BridgeType.A_STAR -> Component.m_237115_((String)"item.pipe_connector.gui.button.aStarPathfinding");
            default -> Component.m_237115_((String)"item.pipe_connector.gui.button.defaultPathfinding");
        };
    }

    @Override
    public List<Component> getTooltipList(ItemStack itemStack) {
        ArrayList<Component> tooltipList = new ArrayList<Component>();
        tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.Pathfinding"));
        if (TagUtils.getBridgeType(itemStack) == BridgeType.DEFAULT) {
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.defaultPathfindingImportantInfo").m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.performanceImpact").m_130940_(ChatFormatting.GRAY));
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.performanceImpactLow").m_130940_(ChatFormatting.YELLOW));
            return tooltipList;
        }
        if (TagUtils.getBridgeType(itemStack) == BridgeType.A_STAR) {
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.aStarPathfindingImportantInfo").m_130940_(ChatFormatting.GOLD));
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.performanceImpact").m_130940_(ChatFormatting.GRAY));
            tooltipList.add((Component)Component.m_237115_((String)"item.pipe_connector.gui.tooltip.performanceImpactMediumHigh").m_130940_(ChatFormatting.YELLOW));
            return tooltipList;
        }
        return null;
    }
}

